"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.confirmUpdate = confirmUpdate;
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _get_count = require("./services/get_count");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765022786381327106/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/fleet/public/applications/fleet/sections/settings/components/download_source_flyout/confirm_update.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const ConfirmDescription = ({
  downloadSource,
  agentCount,
  agentPolicyCount
}) => agentCount !== undefined && agentPolicyCount !== undefined ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.fleet.settings.updateDownloadSourceModal.confirmModalText",
  "data-test-subj": "editDownloadSourcesConfirmModal.confirmModalText",
  defaultMessage: "This action will update {downloadSourceName} agent binary source. It will update {policies} and {agents}. This action can not be undone. Are you sure you wish to continue?",
  values: {
    downloadSourceName: /*#__PURE__*/_react.default.createElement("strong", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 33,
        columnNumber: 29
      }
    }, downloadSource.name),
    agents: /*#__PURE__*/_react.default.createElement("strong", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 35,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.settings.updateDownloadSourceModal.agentsCount",
      defaultMessage: "{agentCount, plural, one {# agent} other {# agents}}",
      values: {
        agentCount
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 36,
        columnNumber: 13
      }
    })),
    policies: /*#__PURE__*/_react.default.createElement("strong", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 46,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.settings.updateDownloadSourceModal.agentPolicyCount",
      defaultMessage: "{agentPolicyCount, plural, one {# agent policy} other {# agent policies}}",
      values: {
        agentPolicyCount
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 47,
        columnNumber: 13
      }
    }))
  },
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 28,
    columnNumber: 5
  }
}) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.fleet.settings.updateDownloadSourceModal.confirmModalTextWithoutCount",
  "data-test-subj": "editDownloadSourcesConfirmModal.confirmModalText",
  defaultMessage: "This action will update {downloadSourceName} agent binary source. It will update related policies and agents. This action can not be undone. Are you sure you wish to continue?",
  values: {
    downloadSourceName: /*#__PURE__*/_react.default.createElement("strong", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 64,
        columnNumber: 29
      }
    }, downloadSource.name)
  },
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 59,
    columnNumber: 5
  }
});
async function confirmUpdate(downloadSource, confirm) {
  const {
    agentCount,
    agentPolicyCount
  } = await (0, _get_count.getCountsForDownloadSource)(downloadSource).catch(() => ({
    //  Fail gracefully when counts are not avaiable
    agentCount: undefined,
    agentPolicyCount: undefined
  }));
  return confirm(/*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.settings.updateDownloadSourceModal.confirmModalTitle",
    defaultMessage: "Save and deploy changes?",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 81,
      columnNumber: 5
    }
  }), /*#__PURE__*/_react.default.createElement(ConfirmDescription, {
    agentCount: agentCount,
    agentPolicyCount: agentPolicyCount,
    downloadSource: downloadSource,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 85,
      columnNumber: 5
    }
  }));
}