"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AgentLogsUrlStateHelper = exports.AgentLogsUI = void 0;
var _react = _interopRequireWildcard(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _esQuery = require("@kbn/es-query");
var _gte = _interopRequireDefault(require("semver/functions/gte"));
var _coerce = _interopRequireDefault(require("semver/functions/coerce"));
var _public = require("@kbn/kibana-utils-plugin/public");
var _sharedUxLinkRedirectApp = require("@kbn/shared-ux-link-redirect-app");
var _savedSearchComponent = require("@kbn/saved-search-component");
var _useAsync = _interopRequireDefault(require("react-use/lib/useAsync"));
var _hooks = require("../../../../../hooks");
var _filter_dataset = require("./filter_dataset");
var _filter_log_level = require("./filter_log_level");
var _query_bar = require("./query_bar");
var _build_query = require("./build_query");
var _view_logs_button = require("./view_logs_button");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765022786381327106/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/fleet/public/applications/fleet/sections/agents/agent_details_page/components/agent_logs/agent_logs.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const WrapperFlexGroup = (0, _styledComponents.default)(_eui.EuiFlexGroup)`
  height: 100%;
`;
const DatePickerFlexItem = (0, _styledComponents.default)(_eui.EuiFlexItem)`
  max-width: 312px;
`;
const AgentLogsUrlStateHelper = exports.AgentLogsUrlStateHelper = (0, _public.createStateContainerReactHelpers)();
const AgentPolicyLogsNotEnabledCallout = ({
  agentPolicy
}) => {
  const {
    getHref
  } = (0, _hooks.useLink)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 68,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    size: "m",
    color: "primary",
    iconType: "info",
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentLogs.logDisabledCallOutTitle",
      defaultMessage: "Log collection is disabled",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 74,
        columnNumber: 11
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 69,
      columnNumber: 7
    }
  }, agentPolicy.is_managed ? null : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.agentLogs.logDisabledCallOutDescription",
    defaultMessage: "Update the agent's policy {settingsLink} to enable logs collection.",
    values: {
      settingsLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        href: getHref('policy_details', {
          policyId: agentPolicy.id,
          tabId: 'settings'
        }),
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 86,
          columnNumber: 17
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.agentLogs.settingsLink",
        defaultMessage: "settings",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 92,
          columnNumber: 19
        }
      }))
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 81,
      columnNumber: 11
    }
  })));
};
const AgentLogsUI = exports.AgentLogsUI = /*#__PURE__*/(0, _react.memo)(({
  agent,
  agentPolicy,
  state
}) => {
  var _agent$local_metadata, _agent$local_metadata2, _agent$local_metadata3, _agentPolicy$monitori;
  const {
    application,
    logsDataAccess: {
      services: {
        logSourcesService
      }
    },
    embeddable,
    data: {
      search: {
        searchSource
      },
      query: {
        timefilter: {
          timefilter: dataTimefilter
        }
      },
      dataViews
    }
  } = (0, _hooks.useStartServices)();
  const logSources = (0, _useAsync.default)(logSourcesService.getFlattenedLogSources);
  const {
    update: updateState
  } = AgentLogsUrlStateHelper.useTransitions();

  // Util to convert date expressions (returned by datepicker) to timestamps (used by LogStream)
  const getDateRangeTimestamps = (0, _react.useCallback)(timeRange => {
    const {
      min,
      max
    } = dataTimefilter.calculateBounds(timeRange);
    return min && max ? {
      start: min.valueOf(),
      end: max.valueOf()
    } : undefined;
  }, [dataTimefilter]);
  const tryUpdateDateRange = (0, _react.useCallback)(timeRange => {
    const timestamps = getDateRangeTimestamps(timeRange);
    if (timestamps) {
      updateState({
        start: timeRange.from,
        end: timeRange.to
      });
    }
  }, [getDateRangeTimestamps, updateState]);
  // Query validation helper
  const isQueryValid = (0, _react.useCallback)(testQuery => {
    try {
      (0, _esQuery.fromKueryExpression)(testQuery);
      return true;
    } catch (err) {
      return false;
    }
  }, []);

  // User query state
  const [draftQuery, setDraftQuery] = (0, _react.useState)(state.query);
  const [isDraftQueryValid, setIsDraftQueryValid] = (0, _react.useState)(isQueryValid(state.query));
  const onUpdateDraftQuery = (0, _react.useCallback)((newDraftQuery, runQuery) => {
    setDraftQuery(newDraftQuery);
    if (isQueryValid(newDraftQuery)) {
      setIsDraftQueryValid(true);
      if (runQuery) {
        updateState({
          query: newDraftQuery
        });
      }
    } else {
      setIsDraftQueryValid(false);
    }
  }, [isQueryValid, updateState]);

  // Build final log stream query from agent id, datasets, log levels, and user input
  const logStreamQuery = (0, _react.useMemo)(() => ({
    language: 'kuery',
    query: (0, _build_query.buildQuery)({
      agentId: agent.id,
      datasets: state.datasets,
      logLevels: state.logLevels,
      userQuery: state.query
    })
  }), [agent.id, state.datasets, state.logLevels, state.query]);
  const agentVersion = (_agent$local_metadata = agent.local_metadata) === null || _agent$local_metadata === void 0 ? void 0 : (_agent$local_metadata2 = _agent$local_metadata.elastic) === null || _agent$local_metadata2 === void 0 ? void 0 : (_agent$local_metadata3 = _agent$local_metadata2.agent) === null || _agent$local_metadata3 === void 0 ? void 0 : _agent$local_metadata3.version;
  const isLogFeatureAvailable = (0, _react.useMemo)(() => {
    var _semverCoerce;
    if (!agentVersion) {
      return false;
    }
    const agentVersionWithPrerelease = (_semverCoerce = (0, _coerce.default)(agentVersion)) === null || _semverCoerce === void 0 ? void 0 : _semverCoerce.version;
    if (!agentVersionWithPrerelease) {
      return false;
    }
    return (0, _gte.default)(agentVersionWithPrerelease, '7.11.0');
  }, [agentVersion]);
  if (!isLogFeatureAvailable) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      size: "m",
      color: "warning",
      title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.agentLogs.oldAgentWarningTitle",
        defaultMessage: "The Logs view requires Elastic Agent 7.11 or higher. To upgrade an agent, go to the Actions menu, or {downloadLink} a newer version.",
        values: {
          downloadLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
            href: "https://ela.st/download-elastic-agent",
            external: true,
            target: "_blank",
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 218,
              columnNumber: 19
            }
          }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
            id: "xpack.fleet.agentLogs.downloadLink",
            defaultMessage: "download",
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 219,
              columnNumber: 21
            }
          }))
        },
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 213,
          columnNumber: 13
        }
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 209,
        columnNumber: 9
      }
    });
  }
  return /*#__PURE__*/_react.default.createElement(WrapperFlexGroup, {
    direction: "column",
    gutterSize: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 233,
      columnNumber: 7
    }
  }, agentPolicy && !((_agentPolicy$monitori = agentPolicy.monitoring_enabled) !== null && _agentPolicy$monitori !== void 0 && _agentPolicy$monitori.includes('logs')) && /*#__PURE__*/_react.default.createElement(AgentPolicyLogsNotEnabledCallout, {
    agentPolicy: agentPolicy,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 235,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 237,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 238,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 239,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_query_bar.LogQueryBar, {
    query: draftQuery,
    onUpdateQuery: onUpdateDraftQuery,
    isQueryValid: isDraftQueryValid,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 240,
      columnNumber: 15
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 246,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFilterGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 247,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_filter_dataset.DatasetFilter, {
    selectedDatasets: state.datasets,
    onToggleDataset: dataset => {
      const currentDatasets = [...state.datasets];
      const datasetPosition = currentDatasets.indexOf(dataset);
      if (datasetPosition >= 0) {
        currentDatasets.splice(datasetPosition, 1);
        updateState({
          datasets: currentDatasets
        });
      } else {
        updateState({
          datasets: [...state.datasets, dataset]
        });
      }
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 248,
      columnNumber: 17
    }
  }), /*#__PURE__*/_react.default.createElement(_filter_log_level.LogLevelFilter, {
    selectedLevels: state.logLevels,
    onToggleLevel: level => {
      const currentLevels = [...state.logLevels];
      const levelPosition = currentLevels.indexOf(level);
      if (levelPosition >= 0) {
        currentLevels.splice(levelPosition, 1);
        updateState({
          logLevels: currentLevels
        });
      } else {
        updateState({
          logLevels: [...state.logLevels, level]
        });
      }
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 261,
      columnNumber: 17
    }
  }))), /*#__PURE__*/_react.default.createElement(DatePickerFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 276,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSuperDatePicker, {
    showUpdateButton: false,
    start: state.start,
    end: state.end,
    onTimeChange: ({
      start,
      end
    }) => {
      tryUpdateDateRange({
        from: start,
        to: end
      });
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 277,
      columnNumber: 15
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 289,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_sharedUxLinkRedirectApp.RedirectAppLinks, {
    coreStart: {
      application
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 290,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_view_logs_button.ViewLogsButton, {
    logStreamQuery: logStreamQuery.query,
    startTime: (0, _view_logs_button.getFormattedRange)(state.start),
    endTime: (0, _view_logs_button.getFormattedRange)(state.end),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 295,
      columnNumber: 17
    }
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 304,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    paddingSize: "none",
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 305,
      columnNumber: 11
    }
  }, logSources.value ? /*#__PURE__*/_react.default.createElement(_savedSearchComponent.LazySavedSearchComponent, {
    dependencies: {
      embeddable,
      searchSource,
      dataViews
    },
    index: logSources.value,
    timeRange: {
      from: state.start,
      to: state.end
    },
    query: logStreamQuery,
    height: "60vh",
    displayOptions: {
      enableDocumentViewer: true,
      enableFilters: false
    },
    columns: ['@timestamp', 'event.dataset', 'component.id', 'message', 'error.message'],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 307,
      columnNumber: 15
    }
  }) : null)));
});