"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GeoUploadWizard = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _public = require("@kbn/data-plugin/public");
var _kibana_services = require("../kibana_services");
var _geo_upload_form = require("./geo_upload_form");
var _import_complete_view = require("./import_complete_view");
var _api = require("../api");
var _utils = require("./utils");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765022786381327106/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/file_upload/public/components/geo_upload_wizard.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
var PHASE = /*#__PURE__*/function (PHASE) {
  PHASE["CONFIGURE"] = "CONFIGURE";
  PHASE["IMPORT"] = "IMPORT";
  PHASE["COMPLETE"] = "COMPLETE";
  return PHASE;
}(PHASE || {});
function getWritingToIndexMsg(progress) {
  return _i18n.i18n.translate('xpack.fileUpload.geoUploadWizard.writingToIndex', {
    defaultMessage: 'Writing to index: {progress}% complete',
    values: {
      progress
    }
  });
}
class GeoUploadWizard extends _react.Component {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "_geoFileImporter", void 0);
    (0, _defineProperty2.default)(this, "_isMounted", false);
    (0, _defineProperty2.default)(this, "state", {
      failedPermissionCheck: false,
      geoFieldType: _public.ES_FIELD_TYPES.GEO_SHAPE,
      importStatus: '',
      indexName: '',
      indexSettings: JSON.stringify({}, null, 2),
      phase: PHASE.CONFIGURE,
      smallChunks: false
    });
    (0, _defineProperty2.default)(this, "_import", async () => {
      var _importResults$failur;
      if (!this._geoFileImporter) {
        return;
      }
      let indexSettings = {};
      try {
        indexSettings = JSON.parse(this.state.indexSettings);
      } catch (error) {
        // allow user to fix index setting parse error in editor
        return;
      }

      //
      // check permissions
      //
      const canImport = await (0, _api.hasImportPermission)({
        checkCreateDataView: true,
        checkHasManagePipeline: false,
        indexName: this.state.indexName
      });
      if (!this._isMounted) {
        return;
      }
      if (!canImport) {
        this.setState({
          phase: PHASE.COMPLETE,
          failedPermissionCheck: true
        });
        this.props.onUploadError();
        return;
      }

      //
      // create index
      //
      const mappings = {
        properties: {
          geometry: {
            type: this.state.geoFieldType
          }
        }
      };
      this.setState({
        importStatus: _i18n.i18n.translate('xpack.fileUpload.geoUploadWizard.dataIndexingStarted', {
          defaultMessage: 'Creating index: {indexName}',
          values: {
            indexName: this.state.indexName
          }
        }),
        phase: PHASE.IMPORT
      });
      this._geoFileImporter.setGeoFieldType(this.state.geoFieldType);
      const initializeImportResp = await this._geoFileImporter.initializeImport(this.state.indexName, indexSettings, mappings, []);
      if (!this._isMounted) {
        return;
      }
      if (initializeImportResp.index === undefined || initializeImportResp.id === undefined) {
        this.setState({
          phase: PHASE.COMPLETE,
          importResults: initializeImportResp
        });
        this.props.onUploadError();
        return;
      }

      //
      // import file
      //
      this.setState({
        importStatus: getWritingToIndexMsg(0)
      });
      this._geoFileImporter.setSmallChunks(this.state.smallChunks);
      const importResults = await this._geoFileImporter.import(this.state.indexName, initializeImportResp.pipelineIds[0], progress => {
        if (this._isMounted) {
          this.setState({
            importStatus: getWritingToIndexMsg(progress)
          });
        }
      });
      if (!this._isMounted) {
        return;
      }
      if (!importResults.success) {
        this.setState({
          importResults,
          importStatus: _i18n.i18n.translate('xpack.fileUpload.geoUploadWizard.dataIndexingError', {
            defaultMessage: 'Data indexing error'
          }),
          phase: PHASE.COMPLETE
        });
        this.props.onUploadError();
        return;
      } else if (importResults.docCount === ((_importResults$failur = importResults.failures) === null || _importResults$failur === void 0 ? void 0 : _importResults$failur.length)) {
        this.setState({
          // Force importResults into failure shape when no features are indexed
          importResults: {
            ...importResults,
            success: false,
            error: {
              error: {
                reason: (0, _utils.getPartialImportMessage)(importResults.failures.length, importResults.docCount)
              }
            }
          },
          phase: PHASE.COMPLETE
        });
        this.props.onUploadError();
        return;
      }

      //
      // create index pattern
      //
      this.setState({
        importResults,
        importStatus: _i18n.i18n.translate('xpack.fileUpload.geoUploadWizard.creatingDataView', {
          defaultMessage: 'Creating data view: {indexName}',
          values: {
            indexName: this.state.indexName
          }
        })
      });
      let dataView;
      let results;
      try {
        dataView = await (0, _kibana_services.getDataViewsService)().createAndSave({
          title: this.state.indexName
        }, true);
        if (!dataView.id) {
          throw new Error('id not provided');
        }
        const geoField = dataView.fields.find(field => [_public.ES_FIELD_TYPES.GEO_POINT, _public.ES_FIELD_TYPES.GEO_SHAPE].includes(field.type));
        if (!geoField) {
          throw new Error('geo field not created');
        }
        results = {
          indexPatternId: dataView.id,
          geoFieldName: geoField.name,
          geoFieldType: geoField.type,
          docCount: importResults.docCount !== undefined ? importResults.docCount : 0
        };
      } catch (error) {
        if (this._isMounted) {
          this.setState({
            importStatus: _i18n.i18n.translate('xpack.fileUpload.geoUploadWizard.dataViewError', {
              defaultMessage: 'Unable to create data view'
            }),
            phase: PHASE.COMPLETE
          });
          this.props.onUploadError();
        }
        return;
      }
      if (!this._isMounted) {
        return;
      }

      //
      // Successful import
      //
      this.setState({
        dataViewResp: {
          success: true,
          id: dataView.id,
          fields: dataView.fields
        },
        phase: PHASE.COMPLETE,
        importStatus: ''
      });
      this.props.onUploadComplete(results);
    });
    (0, _defineProperty2.default)(this, "_onFileSelect", ({
      features,
      importer,
      indexName,
      previewCoverage
    }) => {
      this._geoFileImporter = importer;
      this.props.onFileSelect({
        type: 'FeatureCollection',
        features
      }, indexName, previewCoverage);
    });
    (0, _defineProperty2.default)(this, "_onFileClear", () => {
      if (this._geoFileImporter) {
        this._geoFileImporter.destroy();
        this._geoFileImporter = undefined;
      }
      this.props.onFileClear();
    });
    (0, _defineProperty2.default)(this, "_onGeoFieldTypeSelect", geoFieldType => {
      this.setState({
        geoFieldType
      });
    });
    (0, _defineProperty2.default)(this, "_onIndexNameChange", (name, error) => {
      this.setState({
        indexName: name,
        indexNameError: error
      });
      const isReadyToImport = !!name && error === undefined;
      if (isReadyToImport) {
        this.props.enableImportBtn();
      } else {
        this.props.disableImportBtn();
      }
    });
    (0, _defineProperty2.default)(this, "_onIndexSettingsChange", indexSettings => {
      this.setState({
        indexSettings
      });
      try {
        JSON.parse(indexSettings);
        this.props.enableImportBtn();
      } catch (error) {
        this.props.disableImportBtn();
      }
    });
    (0, _defineProperty2.default)(this, "_onSmallChunksChange", smallChunks => {
      this.setState({
        smallChunks
      });
    });
  }
  componentDidMount() {
    this._isMounted = true;
  }
  componentWillUnmount() {
    this._isMounted = false;
    if (this._geoFileImporter) {
      this._geoFileImporter.destroy();
      this._geoFileImporter = undefined;
    }
  }
  componentDidUpdate() {
    if (this.props.isIndexingTriggered && this.state.phase === PHASE.CONFIGURE) {
      this._import();
    }
  }
  render() {
    if (this.state.phase === PHASE.IMPORT) {
      return /*#__PURE__*/_react.default.createElement(_react.Fragment, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 327,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiProgress, {
        size: "xs",
        color: "accent",
        position: "absolute",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 328,
          columnNumber: 11
        }
      }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 329,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement("p", {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 330,
          columnNumber: 13
        }
      }, this.state.importStatus)));
    }
    if (this.state.phase === PHASE.COMPLETE) {
      return /*#__PURE__*/_react.default.createElement(_import_complete_view.ImportCompleteView, {
        importResults: this.state.importResults,
        dataViewResp: this.state.dataViewResp,
        indexName: this.state.indexName,
        failedPermissionCheck: this.state.failedPermissionCheck,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 338,
          columnNumber: 9
        }
      });
    }
    return /*#__PURE__*/_react.default.createElement(_geo_upload_form.GeoUploadForm, {
      geoFieldType: this.state.geoFieldType,
      indexName: this.state.indexName,
      indexNameError: this.state.indexNameError,
      indexSettings: this.state.indexSettings,
      onFileClear: this._onFileClear,
      onFileSelect: this._onFileSelect,
      smallChunks: this.state.smallChunks,
      onGeoFieldTypeSelect: this._onGeoFieldTypeSelect,
      onIndexNameChange: this._onIndexNameChange,
      onIndexNameValidationStart: this.props.disableImportBtn,
      onIndexNameValidationEnd: this.props.enableImportBtn,
      onIndexSettingsChange: this._onIndexSettingsChange,
      onSmallChunksChange: this._onSmallChunksChange,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 348,
        columnNumber: 7
      }
    });
  }
}
exports.GeoUploadWizard = GeoUploadWizard;