"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isRangeAnnotation = exports.getRangeAnnotations = exports.getAnnotationsGroupedByInterval = exports.OUTSIDE_RECT_ANNOTATION_WIDTH_SUGGESTION = exports.OUTSIDE_RECT_ANNOTATION_WIDTH = exports.Annotations = void 0;
var _react = _interopRequireWildcard(require("react"));
var _lodash = require("lodash");
var _charts = require("@elastic/charts");
var _moment = _interopRequireDefault(require("moment"));
var _eui = require("@elastic/eui");
var _eventAnnotationCommon = require("@kbn/event-annotation-common");
var _i18nReact = require("@kbn/i18n-react");
var _react2 = require("@emotion/react");
var _helpers = require("../helpers");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765022786381327106/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/chart_expressions/expression_xy/public/components/annotations.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const TooltipAnnotationDetails = ({
  row,
  extraFields
}) => {
  return extraFields.length > 0 ? /*#__PURE__*/_react.default.createElement("div", {
    css: styles.tooltipExtraFields,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 63,
      columnNumber: 5
    }
  }, extraFields.map(field => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    key: `${field.key}-${field.name}`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 65,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    css: styles.tooltipExtraFieldsKey,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 66,
      columnNumber: 11
    }
  }, field.name, ":"), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    css: styles.tooltipExtraFieldsValue,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 67,
      columnNumber: 11
    }
  }, field.formatter ? field.formatter.convert(row[field.key]) : row[field.key])))) : null;
};
const getExtraFields = (row, formatFactory, columns) => {
  return Object.keys(row).filter(key => key.startsWith('field:')).map(key => {
    var _columns$find, _columns$find$meta;
    const columnFormatter = columns === null || columns === void 0 ? void 0 : (_columns$find = columns.find(c => c.id === key)) === null || _columns$find === void 0 ? void 0 : (_columns$find$meta = _columns$find.meta) === null || _columns$find$meta === void 0 ? void 0 : _columns$find$meta.params;
    return {
      key,
      name: key.replace('field:', ''),
      formatter: columnFormatter && formatFactory(columnFormatter)
    };
  });
};
const DISPLAYED_COUNT_OF_ROWS = 5;
const createCustomTooltip = (rows, formatFactory, columns, timeFormat) => () => {
  const lastElement = rows[rows.length - 1];
  const skippedCountFromRequest = lastElement.skippedCount || 0;
  const displayedSkippedCount = rows.length > DISPLAYED_COUNT_OF_ROWS ? rows.length - DISPLAYED_COUNT_OF_ROWS : 0;
  const skippedCount = skippedCountFromRequest + displayedSkippedCount;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    color: "plain",
    hasShadow: false,
    hasBorder: false,
    paddingSize: "none",
    borderRadius: "none",
    css: styles.tooltip,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 110,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    css: styles.tooltipRows,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 118,
      columnNumber: 9
    }
  }, rows.slice(0, DISPLAYED_COUNT_OF_ROWS).map((row, index) => {
    const extraFields = getExtraFields(row, formatFactory, columns);
    return /*#__PURE__*/_react.default.createElement(_react.Fragment, {
      key: row.time,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 123,
        columnNumber: 15
      }
    }, index > 0 && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "xs",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 126,
        columnNumber: 21
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
      margin: "none",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 127,
        columnNumber: 21
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "xs",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 128,
        columnNumber: 21
      }
    })), /*#__PURE__*/_react.default.createElement("div", {
      css: styles.tooltipRow,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 131,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "xs",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 132,
        columnNumber: 19
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 133,
        columnNumber: 21
      }
    }, /*#__PURE__*/_react.default.createElement(_helpers.AnnotationIcon, {
      type: (0, _helpers.hasIcon)(row.icon) ? row.icon : 'empty',
      color: row.color,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 134,
        columnNumber: 23
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 139,
        columnNumber: 21
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "xxxs",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 140,
        columnNumber: 23
      }
    }, /*#__PURE__*/_react.default.createElement("h6", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 141,
        columnNumber: 25
      }
    }, row.label)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 143,
        columnNumber: 23
      }
    }, (0, _moment.default)(row.time).format(timeFormat)), /*#__PURE__*/_react.default.createElement(TooltipAnnotationDetails, {
      key: (0, _lodash.snakeCase)(row.time),
      row: row,
      extraFields: extraFields,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 144,
        columnNumber: 23
      }
    })))));
  })), skippedCount ? /*#__PURE__*/_react.default.createElement("div", {
    css: styles.tooltipSkippedCount,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 157,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 158,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "none",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 159,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 160,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement("div", {
    css: styles.tooltipRow,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 161,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "expressionXY.annotations.skippedCount",
    defaultMessage: "+{value} more\u2026",
    values: {
      value: skippedCount
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 162,
      columnNumber: 15
    }
  }))) : null);
};
function getCommonProperty(configArr, propertyName, fallbackValue) {
  const firstStyle = configArr[0][propertyName];
  if (configArr.every(config => firstStyle === config[propertyName])) {
    return firstStyle;
  }
  return fallbackValue;
}
const getCommonStyles = configArr => {
  return {
    color: getCommonProperty(configArr, 'color', _eventAnnotationCommon.defaultAnnotationColor),
    lineWidth: getCommonProperty(configArr, 'lineWidth', 1),
    lineStyle: getCommonProperty(configArr, 'lineStyle', 'solid'),
    textVisibility: getCommonProperty(configArr, 'textVisibility', false)
  };
};
const isRangeAnnotation = row => 'type' in row && row.type === 'range';
exports.isRangeAnnotation = isRangeAnnotation;
const getRangeAnnotations = datatable => datatable.rows.filter(row => 'type' in row && row.type === 'range');
exports.getRangeAnnotations = getRangeAnnotations;
const OUTSIDE_RECT_ANNOTATION_WIDTH = exports.OUTSIDE_RECT_ANNOTATION_WIDTH = 8;
const OUTSIDE_RECT_ANNOTATION_WIDTH_SUGGESTION = exports.OUTSIDE_RECT_ANNOTATION_WIDTH_SUGGESTION = 2;
const getAnnotationsGroupedByInterval = (annotations, configs, columns, formatFactory, timeFormat) => {
  const visibleGroupedConfigs = annotations.reduce((acc, current) => {
    const timebucket = (0, _moment.default)(current.timebucket).valueOf();
    return {
      ...acc,
      [timebucket]: acc[timebucket] ? [...acc[timebucket], current] : [current]
    };
  }, {});
  return Object.entries(visibleGroupedConfigs).map(([timebucket, rowsPerBucket]) => {
    var _columns$find2, _columns$find2$meta;
    const firstRow = rowsPerBucket[0];
    const config = configs === null || configs === void 0 ? void 0 : configs.find(c => c.id === firstRow.id);
    const textField = config && 'textField' in config && (config === null || config === void 0 ? void 0 : config.textField);
    const columnFormatter = columns === null || columns === void 0 ? void 0 : (_columns$find2 = columns.find(c => c.id === `field:${textField}`)) === null || _columns$find2 === void 0 ? void 0 : (_columns$find2$meta = _columns$find2.meta) === null || _columns$find2$meta === void 0 ? void 0 : _columns$find2$meta.params;
    const formatter = columnFormatter && formatFactory(columnFormatter);
    const label = textField && formatter && `field:${textField}` in firstRow ? formatter.convert(firstRow[`field:${textField}`]) : firstRow.label;
    const mergedAnnotation = {
      ...firstRow,
      label,
      icon: firstRow.icon || 'triangle',
      timebucket: Number(timebucket),
      position: 'bottom',
      customTooltip: createCustomTooltip(rowsPerBucket, formatFactory, columns, timeFormat),
      isGrouped: false
    };
    if (rowsPerBucket.length > 1) {
      const commonStyles = getCommonStyles(rowsPerBucket);
      return {
        ...mergedAnnotation,
        ...commonStyles,
        label: '',
        isGrouped: true,
        icon: String(rowsPerBucket.length)
      };
    }
    return mergedAnnotation;
  });
};

// todo: remove when closed https://github.com/elastic/elastic-charts/issues/1647
exports.getAnnotationsGroupedByInterval = getAnnotationsGroupedByInterval;
_charts.RectAnnotation.displayName = 'RectAnnotation';
const Annotations = ({
  groupedLineAnnotations,
  rangeAnnotations,
  timeFormat,
  isHorizontal,
  paddingMap,
  simpleView,
  minInterval,
  isBarChart,
  outsideDimension
}) => {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, groupedLineAnnotations.map(annotation => {
    const markerPositionVertical = _charts.Position.Top;
    const hasReducedPadding = paddingMap[markerPositionVertical] === _helpers.LINES_MARKER_SIZE;
    const {
      timebucket,
      time,
      isGrouped,
      id: configId
    } = annotation;
    const strokeWidth = simpleView ? 1 : annotation.lineWidth || 1;
    const id = (0, _lodash.snakeCase)(`${configId}-${time}`);
    const markerBodyLabel = !simpleView && !isGrouped && annotation.textVisibility && !hasReducedPadding ? annotation.label : undefined;
    return /*#__PURE__*/_react.default.createElement(_charts.LineAnnotation, {
      id: id,
      key: id,
      domainType: _charts.AnnotationDomainType.XDomain,
      marker: !simpleView ? /*#__PURE__*/_react.default.createElement(_helpers.Marker, {
        config: annotation,
        isHorizontal: !isHorizontal,
        hasReducedPadding,
        label: !isGrouped ? annotation.label : undefined,
        rotateClassName: isHorizontal ? 'xyAnnotationIcon_rotate90' : undefined,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 294,
          columnNumber: 17
        }
      }) : undefined,
      markerBody: markerBodyLabel ? /*#__PURE__*/_react.default.createElement(_helpers.MarkerBody, {
        label: markerBodyLabel,
        isHorizontal: !isHorizontal,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 307,
          columnNumber: 17
        }
      }) : undefined,
      markerPosition: isHorizontal ? (0, _helpers.mapVerticalToHorizontalPlacement)(markerPositionVertical) : markerPositionVertical,
      dataValues: [{
        dataValue: isGrouped ? (0, _moment.default)(isBarChart && minInterval ? timebucket + minInterval / 2 : timebucket).valueOf() : (0, _moment.default)(time).valueOf(),
        details: annotation.label
      }],
      customTooltip: annotation.customTooltip,
      placement: "bottom",
      style: {
        line: {
          strokeWidth,
          stroke: annotation.color || _eventAnnotationCommon.defaultAnnotationColor,
          dash: annotation.lineStyle === 'dashed' ? [strokeWidth * 3, strokeWidth] : annotation.lineStyle === 'dotted' ? [strokeWidth, strokeWidth] : undefined,
          opacity: 1
        }
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 288,
        columnNumber: 11
      }
    });
  }), rangeAnnotations.map(({
    id,
    label,
    time,
    color,
    endTime,
    outside
  }) => {
    return /*#__PURE__*/_react.default.createElement(_charts.RectAnnotation, {
      id: id,
      key: id,
      customTooltip: () => /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
        color: "plain",
        hasShadow: false,
        hasBorder: false,
        paddingSize: "none",
        borderRadius: "none",
        css: styles.tooltip,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 349,
          columnNumber: 15
        }
      }, /*#__PURE__*/_react.default.createElement("div", {
        css: styles.tooltipRow,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 357,
          columnNumber: 17
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        gutterSize: "xs",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 358,
          columnNumber: 19
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 359,
          columnNumber: 21
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        type: "stopFilled",
        color: color,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 360,
          columnNumber: 23
        }
      })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 362,
          columnNumber: 21
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
        size: "xxxs",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 363,
          columnNumber: 23
        }
      }, /*#__PURE__*/_react.default.createElement("h6", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 364,
          columnNumber: 25
        }
      }, label)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 366,
          columnNumber: 23
        }
      }, `${(0, _moment.default)(time).format(timeFormat)} — ${(0, _moment.default)(endTime).format(timeFormat)}`))))),
      dataValues: [{
        coordinates: {
          x0: (0, _moment.default)(time).valueOf(),
          x1: (0, _moment.default)(endTime).valueOf()
        },
        details: label
      }],
      style: {
        fill: color || _eventAnnotationCommon.defaultAnnotationRangeColor,
        opacity: 1
      },
      outside: Boolean(outside),
      outsideDimension: outsideDimension,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 345,
        columnNumber: 11
      }
    });
  }));
};
exports.Annotations = Annotations;
const styles = {
  tooltip: (0, _react2.css)({
    borderRadius: '0 !important'
  }),
  tooltipRows: (0, _react2.css)({
    // maxHeight: '60vh',
    overflowY: 'hidden'
  }),
  tooltipRow: ({
    euiTheme
  }) => (0, _react2.css)({
    fontWeight: euiTheme.font.weight.regular,
    padding: `${euiTheme.size.s} ${euiTheme.size.m} ${euiTheme.size.s} ${euiTheme.size.s}`,
    borderRadius: '0 !important'
  }),
  tooltipExtraFields: ({
    euiTheme
  }) => (0, _react2.css)({
    color: euiTheme.colors.darkShade,
    marginTop: euiTheme.size.s
  }),
  tooltipExtraFieldsKey: (0, _react2.css)({
    overflowWrap: 'anywhere',
    hyphens: 'auto'
  }),
  tooltipExtraFieldsValue: (0, _react2.css)({
    textAlign: 'right',
    overflowWrap: 'anywhere',
    hyphens: 'auto'
  }),
  tooltipSkippedCount: ({
    euiTheme
  }) => (0, _react2.css)({
    position: 'relative',
    textAlign: 'right',
    fontWeight: euiTheme.font.weight.regular
  })
};