"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SeriesChartTypes = SeriesChartTypes;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/kibana-react-plugin/public");
var _public2 = require("@kbn/observability-shared-plugin/public");
var _chart_types = require("./chart_types");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765022786381327106/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/exploratory_view/public/components/shared/exploratory_view/series_editor/columns/chart_type_select.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function SeriesChartTypes({
  seriesId,
  series,
  seriesConfig
}) {
  var _series$seriesType, _find, _find2;
  const seriesType = (_series$seriesType = series === null || series === void 0 ? void 0 : series.seriesType) !== null && _series$seriesType !== void 0 ? _series$seriesType : seriesConfig.defaultSeriesType;
  const {
    services: {
      lens
    }
  } = (0, _public.useKibana)();
  const {
    data = []
  } = (0, _public2.useFetcher)(() => lens.getXyVisTypes(), [lens]);
  const icon = (_find = (data !== null && data !== void 0 ? data : []).find(({
    id
  }) => id === seriesType)) === null || _find === void 0 ? void 0 : _find.icon;
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react.useState)(false);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    isOpen: isPopoverOpen,
    closePopover: () => setIsPopoverOpen(false),
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: EDIT_CHART_TYPE_LABEL,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 42,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      "data-test-subj": "o11ySeriesChartTypesButton",
      size: "s",
      "aria-label": CHART_TYPE_LABEL,
      onClick: () => setIsPopoverOpen(prevState => !prevState),
      flush: "both",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 43,
        columnNumber: 11
      }
    }, icon && /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: (_find2 = (data !== null && data !== void 0 ? data : []).find(({
        id
      }) => id === seriesType)) === null || _find2 === void 0 ? void 0 : _find2.icon,
      size: "l",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 51,
        columnNumber: 15
      }
    }))),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 38,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_chart_types.SeriesChartTypesSelect, {
    seriesId: seriesId,
    series: series,
    defaultChartType: seriesConfig.defaultSeriesType,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 57,
      columnNumber: 7
    }
  }));
}
const EDIT_CHART_TYPE_LABEL = _i18n.i18n.translate('xpack.exploratoryView.expView.seriesEditor.editChartSeriesLabel', {
  defaultMessage: 'Edit chart type for series'
});
const CHART_TYPE_LABEL = _i18n.i18n.translate('xpack.exploratoryView.expView.chartTypes.label', {
  defaultMessage: 'Chart type'
});