"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getExploratoryViewEmbeddable = getExploratoryViewEmbeddable;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _public = require("@kbn/kibana-react-plugin/public");
var _styled = _interopRequireDefault(require("@emotion/styled"));
var _i18n = require("@kbn/i18n");
var _public2 = require("@kbn/observability-shared-plugin/public");
var _use_app_data_view = require("./use_app_data_view");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765022786381327106/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/exploratory_view/public/components/shared/exploratory_view/embeddable/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const Embeddable = /*#__PURE__*/_react.default.lazy(() => Promise.resolve().then(() => _interopRequireWildcard(require('./embeddable'))));
function ExploratoryViewEmbeddable(props) {
  return /*#__PURE__*/_react.default.createElement(_react.default.Suspense, {
    fallback: /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 25,
        columnNumber: 31
      }
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 25,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(Embeddable, (0, _extends2.default)({}, props, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 26,
      columnNumber: 7
    }
  })));
}
function getExploratoryViewEmbeddable(services, analytics) {
  const {
    lens,
    dataViews: dataViewsService
  } = services;
  const dataViewCache = {};
  const lenStateHelperPromise = null;
  const lastRefreshed = {};
  const hasSameTimeRange = props => {
    const {
      attributes
    } = props;
    if (!attributes || (attributes === null || attributes === void 0 ? void 0 : attributes.length) === 0) {
      return false;
    }
    const series = attributes[0];
    const {
      time
    } = series;
    const {
      from,
      to
    } = time;
    return attributes.every(seriesT => {
      const {
        time: timeT
      } = seriesT;
      return timeT.from === from && timeT.to === to;
    });
  };
  return props => {
    (0, _react.useEffect)(() => {
      if (!services.data.search.session.getSessionId()) {
        services.data.search.session.start();
      }
    }, []);
    const {
      dataTypesIndexPatterns,
      attributes,
      customHeight
    } = props;
    if (!dataViewsService || !lens || !attributes || (attributes === null || attributes === void 0 ? void 0 : attributes.length) === 0) {
      return null;
    }
    const series = attributes[0];
    const {
      data: lensHelper,
      loading: lensLoading
    } = (0, _public2.useFetcher)(async () => {
      if (lenStateHelperPromise) {
        return lenStateHelperPromise;
      }
      return lens.stateHelperApi();
    }, []);
    const [loadCount, setLoadCount] = (0, _react.useState)(0);
    const onLensLoaded = (0, _react.useCallback)(lensLoaded => {
      if (lensLoaded && props.id && hasSameTimeRange(props) && !lastRefreshed[props.id]) {
        lastRefreshed[props.id] = series.time;
      }
      setLoadCount(prev => prev + 1);
    }, [props, series.time]);
    const {
      dataViews,
      loading
    } = (0, _use_app_data_view.useAppDataView)({
      series,
      dataViewCache,
      dataViewsService,
      dataTypesIndexPatterns,
      seriesDataType: series === null || series === void 0 ? void 0 : series.dataType
    });
    const embedProps = (0, _react.useMemo)(() => {
      const newProps = {
        ...props
      };
      if (props.sparklineMode) {
        newProps.axisTitlesVisibility = {
          x: false,
          yRight: false,
          yLeft: false
        };
        newProps.legendIsVisible = false;
        newProps.hideTicks = true;
      }
      if (props.id && lastRefreshed[props.id] && loadCount < 2) {
        var _props$attributes;
        newProps.attributes = (_props$attributes = props.attributes) === null || _props$attributes === void 0 ? void 0 : _props$attributes.map(seriesT => ({
          ...seriesT,
          time: lastRefreshed[props.id]
        }));
      } else if (props.id) {
        lastRefreshed[props.id] = series.time;
      }
      return newProps;
    }, [loadCount, props, series.time]);
    if (Object.keys(dataViews).length === 0 || loading || !lensHelper || lensLoading) {
      return /*#__PURE__*/_react.default.createElement(LoadingWrapper, {
        customHeight: customHeight,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 119,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
        size: "l",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 120,
          columnNumber: 11
        }
      }));
    }
    if (!dataViews[series === null || series === void 0 ? void 0 : series.dataType]) {
      return /*#__PURE__*/_react.default.createElement(EmptyState, {
        height: props.customHeight,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 126,
          columnNumber: 14
        }
      });
    }
    return /*#__PURE__*/_react.default.createElement(_public.KibanaContextProvider, {
      services: services,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 130,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(Wrapper, {
      customHeight: props.customHeight,
      "data-test-subj": props.dataTestSubj,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 131,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(ExploratoryViewEmbeddable, (0, _extends2.default)({}, embedProps, {
      dataViewState: dataViews,
      lens: lens,
      searchSessionId: services.data.search.session.getSessionId(),
      onLoad: onLensLoaded,
      analytics: analytics,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 132,
        columnNumber: 11
      }
    }))));
  };
}
const Wrapper = _styled.default.div`
  height: ${props => props.customHeight ? `${props.customHeight};` : `100%;`};
`;
const LoadingWrapper = _styled.default.div`
  height: ${props => props.customHeight ? `${props.customHeight};` : `100%;`};
  display: flex;
  align-items: center;
  justify-content: center;
`;
function EmptyState({
  height
}) {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    justifyContent: "center",
    style: {
      height: height !== null && height !== void 0 ? height : '100%'
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 163,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 164,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("span", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 165,
      columnNumber: 9
    }
  }, NO_DATA_LABEL)));
}
const NO_DATA_LABEL = _i18n.i18n.translate('xpack.exploratoryView.noData', {
  defaultMessage: 'No data'
});