"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MultiContentConsumer = void 0;
exports.MultiContentProvider = MultiContentProvider;
exports.useContent = useContent;
exports.useMultiContentContext = useMultiContentContext;
var _react = _interopRequireWildcard(require("react"));
var _use_multi_content = require("./use_multi_content");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765022786381327106/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/es_ui_shared/public/forms/multi_content/multi_content_context.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const multiContentContext = /*#__PURE__*/(0, _react.createContext)({});
function MultiContentProvider({
  defaultValue,
  onChange,
  children
}) {
  const multiContent = (0, _use_multi_content.useMultiContent)({
    defaultValue,
    onChange
  });
  return /*#__PURE__*/_react.default.createElement(multiContentContext.Provider, {
    value: multiContent,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 29,
      columnNumber: 5
    }
  }, children);
}
const MultiContentConsumer = exports.MultiContentConsumer = multiContentContext.Consumer;
function useMultiContentContext() {
  const ctx = (0, _react.useContext)(multiContentContext);
  if (Object.keys(ctx).length === 0) {
    throw new Error('useMultiContentContext must be used within a <MultiContentProvider />');
  }
  return ctx;
}

/**
 * Hook to declare a new content and get its defaultValue and a handler to update its content
 *
 * @param contentId The content id to be added to the "contents" map
 */
function useContent(contentId) {
  const isMounted = (0, _react.useRef)(false);
  const defaultValue = (0, _react.useRef)(undefined);
  const {
    updateContentAt,
    saveSnapshotAndRemoveContent,
    getData,
    getSingleContentData
  } = useMultiContentContext();
  const updateContent = (0, _react.useCallback)(content => {
    updateContentAt(contentId, content);
  }, [contentId, updateContentAt]);
  (0, _react.useEffect)(() => {
    return () => {
      // On unmount: save a snapshot of the data and remove content from our contents map
      saveSnapshotAndRemoveContent(contentId);
    };
  }, [contentId, saveSnapshotAndRemoveContent]);
  (0, _react.useEffect)(() => {
    if (isMounted.current === false) {
      isMounted.current = true;
    }
  }, []);
  if (isMounted.current === false) {
    // Only read the default value once, on component mount to avoid re-rendering the
    // consumer each time the multi-content validity ("isValid") changes.
    defaultValue.current = getSingleContentData(contentId);
  }
  return {
    defaultValue: defaultValue.current,
    updateContent,
    getData,
    getSingleContentData
  };
}