"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ZeroShotClassificationInferenceConfiguration = void 0;
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _index_view_logic = require("../../index_view_logic");
var _ml_inference_logic = require("./ml_inference_logic");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765022786381327106/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/search/plugins/enterprise_search/public/applications/enterprise_search_content/components/search_index/pipelines/ml_inference/zero_shot_inference_configuration.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const ZeroShotClassificationInferenceConfiguration = () => {
  var _configuration$infere, _configuration$infere2, _configuration$infere3;
  const {
    ingestionMethod
  } = (0, _kea.useValues)(_index_view_logic.IndexViewLogic);
  const {
    addInferencePipelineModal: {
      configuration
    }
  } = (0, _kea.useValues)(_ml_inference_logic.MLInferenceLogic);
  const {
    setInferencePipelineConfiguration
  } = (0, _kea.useActions)(_ml_inference_logic.MLInferenceLogic);
  const zeroShotLabels = (_configuration$infere = configuration === null || configuration === void 0 ? void 0 : (_configuration$infere2 = configuration.inferenceConfig) === null || _configuration$infere2 === void 0 ? void 0 : (_configuration$infere3 = _configuration$infere2.zero_shot_classification) === null || _configuration$infere3 === void 0 ? void 0 : _configuration$infere3.labels) !== null && _configuration$infere !== void 0 ? _configuration$infere : [];
  const labelOptions = zeroShotLabels.map(label => ({
    label
  }));
  const onLabelChange = selectedLabels => {
    var _configuration$infere4, _configuration$infere5;
    const inferenceConfig = selectedLabels.length === 0 ? undefined : {
      zero_shot_classification: {
        ...((_configuration$infere4 = configuration === null || configuration === void 0 ? void 0 : (_configuration$infere5 = configuration.inferenceConfig) === null || _configuration$infere5 === void 0 ? void 0 : _configuration$infere5.zero_shot_classification) !== null && _configuration$infere4 !== void 0 ? _configuration$infere4 : {}),
        labels: selectedLabels.map(({
          label
        }) => label)
      }
    };
    setInferencePipelineConfiguration({
      ...configuration,
      inferenceConfig
    });
  };
  const onCreateLabel = (labelValue, labels = []) => {
    var _configuration$infere6, _configuration$infere7;
    const normalizedLabelValue = labelValue.trim();
    if (!normalizedLabelValue) return;
    const existingLabel = labels.find(label => label.label === normalizedLabelValue);
    if (existingLabel) return;
    setInferencePipelineConfiguration({
      ...configuration,
      inferenceConfig: {
        zero_shot_classification: {
          ...((_configuration$infere6 = configuration === null || configuration === void 0 ? void 0 : (_configuration$infere7 = configuration.inferenceConfig) === null || _configuration$infere7 === void 0 ? void 0 : _configuration$infere7.zero_shot_classification) !== null && _configuration$infere6 !== void 0 ? _configuration$infere6 : {}),
          labels: [...zeroShotLabels, normalizedLabelValue]
        }
      }
    });
  };
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 65,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.pipelines.addInferencePipelineModal.steps.configure.inference.zeroShot.labels.label', {
      defaultMessage: 'Class labels'
    }),
    fullWidth: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 66,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    fullWidth: true,
    "data-telemetry-id": `entSearchContent-${ingestionMethod}-pipelines-configureInferencePipeline-zeroShot-labels`,
    placeholder: _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.pipelines.addInferencePipelineModal.steps.configure.inference.zeroShot.labels.placeholder', {
      defaultMessage: 'Create labels'
    }),
    options: labelOptions,
    selectedOptions: labelOptions,
    onChange: onLabelChange,
    onCreateOption: onCreateLabel,
    noSuggestions: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 73,
      columnNumber: 9
    }
  })));
};
exports.ZeroShotClassificationInferenceConfiguration = ZeroShotClassificationInferenceConfiguration;