"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SearchApplicationDocsExplorer = void 0;
var _react = _interopRequireWildcard(require("react"));
var _kea = require("kea");
var _useLocalStorage = _interopRequireDefault(require("react-use/lib/useLocalStorage"));
var _eui = require("@elastic/eui");
var _reactSearchUi = require("@elastic/react-search-ui");
var _searchUiEnginesConnector = _interopRequireDefault(require("@elastic/search-ui-engines-connector"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _encode_path_params = require("../../../../shared/encode_path_params");
var _http = require("../../../../shared/http");
var _kibana = require("../../../../shared/kibana");
var _telemetry = require("../../../../shared/telemetry");
var _routes = require("../../../routes");
var _page_template = require("../../layout/page_template");
var _search_application_indices_logic = require("../search_application_indices_logic");
var _search_application_view_logic = require("../search_application_view_logic");
var Styles = _interopRequireWildcard(require("../styles"));
var _api_call_flyout = require("./api_call_flyout");
var _docs_explorer_logic = require("./docs_explorer_logic");
var _document_context = require("./document_context");
var _document_flyout = require("./document_flyout");
var _search_ui_components = require("./search_ui_components");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765022786381327106/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/search/plugins/enterprise_search/public/applications/applications/components/search_application/docs_explorer/docs_explorer.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
class InternalSearchApplicationTransporter {
  constructor(http, searchApplicationName, setLastAPICall) {
    this.http = http;
    this.searchApplicationName = searchApplicationName;
    this.setLastAPICall = setLastAPICall;
  }
  async performRequest(request) {
    const url = `/internal/enterprise_search/search_applications/${this.searchApplicationName}/search`;
    const response = await this.http.post(url, {
      body: JSON.stringify(request)
    });
    this.setLastAPICall({
      request,
      response
    });
    const withUniqueIds = {
      ...response,
      hits: {
        ...response.hits,
        hits: response.hits.hits.map(hit => ({
          ...hit,
          // The `__id` field is the actual document ID.
          __id: hit._id,
          // Search UI expects a unique `_id` for use as a React key but
          // because Search Applications can have multiple indices, keys
          // can be duplicated. Here we prefix the `_id` with the index
          // name to ensure uniqueness.
          _id: `${hit._index}__${hit._id}`
        }))
      }
    };
    return withUniqueIds;
  }
}
const ConfigurationPopover = ({
  searchApplicationName,
  hasSchemaConflicts,
  setCloseConfiguration,
  showConfiguration
}) => {
  const {
    navigateToUrl
  } = (0, _kea.useValues)(_kibana.KibanaLogic);
  const {
    searchApplicationData
  } = (0, _kea.useValues)(_search_application_view_logic.SearchApplicationViewLogic);
  const {
    openDeleteSearchApplicationModal
  } = (0, _kea.useActions)(_search_application_view_logic.SearchApplicationViewLogic);
  const {
    sendEnterpriseSearchTelemetry
  } = (0, _kea.useActions)(_telemetry.TelemetryLogic);
  const [isTourClosed, setTourClosed] = (0, _useLocalStorage.default)('search-application-tour-closed', false);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    anchorPosition: "downCenter",
    isOpen: showConfiguration,
    panelPaddingSize: "none",
    closePopover: setCloseConfiguration,
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center",
      gutterSize: "xs",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 152,
        columnNumber: 11
      }
    }, hasSchemaConflicts && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 155,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "alert",
      color: "danger",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 156,
        columnNumber: 19
      }
    })), !isTourClosed && /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "xs",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 158,
        columnNumber: 35
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 161,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTourStep, {
      display: "block",
      decoration: "beacon",
      content: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 166,
          columnNumber: 19
        }
      }, /*#__PURE__*/_react.default.createElement("p", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 167,
          columnNumber: 21
        }
      }, _i18n.i18n.translate('xpack.enterpriseSearch.searchApplications.searchApplication.docsExplorer.configuration.tourContent', {
        defaultMessage: 'Create your API key, learn about using language clients and find more resources in Connect.'
      }))),
      isStepOpen: !isTourClosed,
      maxWidth: 360,
      hasArrow: true,
      step: 1,
      onFinish: () => {
        setTourClosed(true);
      },
      stepsTotal: 1,
      anchorPosition: "downCenter",
      title: _i18n.i18n.translate('xpack.enterpriseSearch.searchApplications.searchApplication.docsExplorer.configuration.tourTitle', {
        defaultMessage: 'Review our API page to start using your search application'
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 162,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 198,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      color: "primary",
      iconType: "arrowDown",
      iconSide: "right",
      onClick: setCloseConfiguration,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 199,
        columnNumber: 15
      }
    }, _i18n.i18n.translate('xpack.enterpriseSearch.searchApplications.searchApplication.docsExplorer.configuration.buttonTitle', {
      defaultMessage: 'Configuration'
    })))),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 146,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuPanel, {
    style: {
      width: 300
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 216,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    color: "transparent",
    paddingSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 217,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxxs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 218,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 219,
      columnNumber: 15
    }
  }, _i18n.i18n.translate('xpack.enterpriseSearch.searchApplications.searchApplication.docsExplorer.configuration.contentTitle', {
    defaultMessage: 'Content'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "none",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 229,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
    key: "Indices",
    icon: "tableDensityExpanded",
    onClick: () => navigateToUrl((0, _encode_path_params.generateEncodedPath)(_routes.SEARCH_APPLICATION_CONTENT_PATH, {
      contentTabId: _routes.SearchApplicationContentTabs.INDICES,
      searchApplicationName
    })),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 231,
      columnNumber: 11
    }
  }, _i18n.i18n.translate('xpack.enterpriseSearch.searchApplications.searchApplication.docsExplorer.configuration.content.Indices', {
    defaultMessage: 'Indices'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
    key: "Schema",
    icon: hasSchemaConflicts ? /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "warning",
      color: "danger",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 252,
        columnNumber: 40
      }
    }) : 'kqlField',
    onClick: () => navigateToUrl((0, _encode_path_params.generateEncodedPath)(_routes.SEARCH_APPLICATION_CONTENT_PATH, {
      contentTabId: _routes.SearchApplicationContentTabs.SCHEMA,
      searchApplicationName
    })),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 250,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    alignItems: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 262,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.enterpriseSearch.searchApplications.searchApplication.docsExplorer.configuration.content.schema",
    defaultMessage: "Schema",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 263,
      columnNumber: 15
    }
  }), hasSchemaConflicts && /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    color: "danger",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 268,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.enterpriseSearch.searchApplications.searchApplication.docsExplorer.configuration.content.schemaConflict",
    defaultMessage: "Conflict",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 269,
      columnNumber: 19
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    color: "transparent",
    paddingSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 278,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxxs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 279,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 280,
      columnNumber: 15
    }
  }, _i18n.i18n.translate('xpack.enterpriseSearch.searchApplications.searchApplication.docsExplorer.configuration.connectTitle', {
    defaultMessage: 'Connect'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "none",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 290,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
    key: "Api",
    icon: "lock",
    onClick: () => navigateToUrl((0, _encode_path_params.generateEncodedPath)(_routes.SEARCH_APPLICATION_CONNECT_PATH, {
      connectTabId: _routes.SearchApplicationConnectTabs.SEARCHAPI,
      searchApplicationName
    })),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 291,
      columnNumber: 11
    }
  }, _i18n.i18n.translate('xpack.enterpriseSearch.searchApplications.searchApplication.docsExplorer.configuration.connect.Api', {
    defaultMessage: 'API'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    color: "transparent",
    paddingSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 311,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxxs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 312,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 313,
      columnNumber: 15
    }
  }, _i18n.i18n.translate('xpack.enterpriseSearch.searchApplications.searchApplication.docsExplorer.configuration.settingsTitle', {
    defaultMessage: 'Settings'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "none",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 323,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
    key: "delete",
    icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "trash",
      color: "danger",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 326,
        columnNumber: 19
      }
    }),
    onClick: () => {
      if (searchApplicationData) {
        openDeleteSearchApplicationModal();
        sendEnterpriseSearchTelemetry({
          action: 'clicked',
          metric: 'entSearchApplications-searchApplicationView-deleteSearchApplication'
        });
      }
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 324,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
    color: "danger",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 337,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 338,
      columnNumber: 15
    }
  }, _i18n.i18n.translate('xpack.enterpriseSearch.searchApplications.searchApplication.docsExplorer.configuration.settings.delete', {
    defaultMessage: 'Delete this app'
  })))))));
};
const SearchApplicationDocsExplorer = () => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    http
  } = (0, _kea.useValues)(_http.HttpLogic);
  const [showAPICallFlyout, setShowAPICallFlyout] = (0, _react.useState)(false);
  const [showConfigurationPopover, setShowConfigurationPopover] = (0, _react.useState)(false);
  const [lastAPICall, setLastAPICall] = (0, _react.useState)(null);
  const {
    searchApplicationName,
    isLoadingSearchApplication,
    hasSchemaConflicts
  } = (0, _kea.useValues)(_search_application_view_logic.SearchApplicationViewLogic);
  const {
    resultFields,
    sortableFields
  } = (0, _kea.useValues)(_docs_explorer_logic.SearchApplicationDocsExplorerLogic);
  const {
    searchApplicationData
  } = (0, _kea.useValues)(_search_application_indices_logic.SearchApplicationIndicesLogic);
  const config = (0, _react.useMemo)(() => {
    const transporter = new InternalSearchApplicationTransporter(http, searchApplicationName, setLastAPICall);
    const connector = new _searchUiEnginesConnector.default(transporter);
    return {
      alwaysSearchOnInitialLoad: true,
      apiConnector: connector,
      hasA11yNotifications: true,
      searchQuery: {
        result_fields: resultFields
      }
    };
  }, [http, searchApplicationName, setLastAPICall, resultFields]);
  if (!searchApplicationData) return null;
  return /*#__PURE__*/_react.default.createElement(_page_template.EnterpriseSearchApplicationsPageTemplate, {
    pageChrome: [searchApplicationName, _i18n.i18n.translate('xpack.enterpriseSearch.searchApplications.searchApplication.docsExplorer.pageChrome', {
      defaultMessage: 'Docs Explorer'
    })],
    pageViewTelemetry: _routes.SearchApplicationViewTabs.DOCS_EXPLORER,
    isLoading: isLoadingSearchApplication,
    pageHeader: {
      bottomBorder: false,
      css: Styles.searchApplicationHeaderBackgroundColor(euiTheme),
      pageTitle: searchApplicationName,
      rightSideItems: [/*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(ConfigurationPopover, {
        searchApplicationName: searchApplicationName,
        hasSchemaConflicts: hasSchemaConflicts,
        showConfiguration: showConfigurationPopover,
        setCloseConfiguration: () => setShowConfigurationPopover(!showConfigurationPopover),
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 404,
          columnNumber: 13
        }
      }))]
    },
    searchApplicationName: searchApplicationName,
    hasSchemaConflicts: hasSchemaConflicts,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 386,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_document_context.DocumentProvider, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 416,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_reactSearchUi.SearchProvider, {
    config: config,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 417,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 418,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 419,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_reactSearchUi.SearchBox, {
    inputView: ({
      getInputProps
    }) => /*#__PURE__*/_react.default.createElement(_search_ui_components.SearchBar, {
      additionalInputProps: getInputProps({
        append: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
          color: "primary",
          iconType: "eye",
          onClick: () => setShowAPICallFlyout(true),
          isLoading: lastAPICall == null,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 425,
            columnNumber: 25
          }
        }, _i18n.i18n.translate('xpack.enterpriseSearch.searchApplications.searchApplication.docsExplorer.inputView.appendButtonLabel', {
          defaultMessage: 'View API call'
        })),
        placeholder: _i18n.i18n.translate('xpack.enterpriseSearch.searchApplications.searchApplication.docsExplorer.inputView.placeholder', {
          defaultMessage: 'Search'
        })
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 422,
        columnNumber: 19
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 420,
      columnNumber: 15
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 447,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 448,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    css: {
      minWidth: '240px'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 449,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_reactSearchUi.ResultsPerPage, {
    view: _search_ui_components.ResultsPerPageView,
    options: _search_ui_components.RESULTS_PER_PAGE_OPTIONS,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 450,
      columnNumber: 15
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 451,
      columnNumber: 15
    }
  }), /*#__PURE__*/_react.default.createElement(_search_ui_components.Sorting, {
    sortableFields: sortableFields,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 452,
      columnNumber: 15
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 453,
      columnNumber: 15
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 455,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_reactSearchUi.PagingInfo, {
    view: _search_ui_components.PagingInfoView,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 456,
      columnNumber: 15
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 457,
      columnNumber: 15
    }
  }), /*#__PURE__*/_react.default.createElement(_reactSearchUi.Results, {
    view: _search_ui_components.ResultsView,
    resultView: _search_ui_components.ResultView,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 458,
      columnNumber: 15
    }
  })))), /*#__PURE__*/_react.default.createElement(_document_flyout.DocumentFlyout, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 462,
      columnNumber: 9
    }
  }), showAPICallFlyout && lastAPICall && /*#__PURE__*/_react.default.createElement(_api_call_flyout.APICallFlyout, {
    onClose: () => setShowAPICallFlyout(false),
    lastAPICall: lastAPICall,
    searchApplicationName: searchApplicationName,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 464,
      columnNumber: 11
    }
  })));
};
exports.SearchApplicationDocsExplorer = SearchApplicationDocsExplorer;