"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EnterpriseSearchApplicationsPageTemplate = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _kea = require("kea");
var _useObservable = _interopRequireDefault(require("react-use/lib/useObservable"));
var _eui = require("@elastic/eui");
var _constants = require("../../../../../common/constants");
var _kibana = require("../../../shared/kibana");
var _kibana_chrome = require("../../../shared/kibana_chrome");
var _layout = require("../../../shared/layout");
var _telemetry = require("../../../shared/telemetry");
var _maintenance_mode_callout = require("../maintenance_mode_callout/maintenance_mode_callout");
var _header_docs_action = require("../search_application/header_docs_action");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765022786381327106/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/search/plugins/enterprise_search/public/applications/applications/components/layout/page_template.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const EnterpriseSearchApplicationsPageTemplate = ({
  children,
  pageChrome,
  pageViewTelemetry,
  searchApplicationName,
  hasSchemaConflicts,
  restrictWidth = true,
  ...pageTemplateProps
}) => {
  const alwaysReturnNavItems = true;
  const navItems = (0, _layout.useEnterpriseSearchApplicationNav)(searchApplicationName, pageTemplateProps.isEmptyState, hasSchemaConflicts, alwaysReturnNavItems);
  const {
    renderHeaderActions,
    updateSideNavDefinition,
    getChromeStyle$
  } = (0, _kea.useValues)(_kibana.KibanaLogic);
  const chromeStyle = (0, _useObservable.default)(getChromeStyle$(), 'classic');
  const getSelectedAppItems = (0, _react.useCallback)(items => {
    if (!items) return undefined;
    const buildGroup = items.find(item => item.id === 'build');
    if (!buildGroup || !buildGroup.items) return undefined;
    const searchAppsGroup = buildGroup.items.find(item => item.id === 'searchApplications');
    return searchAppsGroup === null || searchAppsGroup === void 0 ? void 0 : searchAppsGroup.items;
  }, []);
  (0, _react.useLayoutEffect)(() => {
    renderHeaderActions(_header_docs_action.SearchApplicationHeaderDocsAction);
    return () => {
      renderHeaderActions();
    };
  }, []);
  (0, _react.useEffect)(() => {
    // We update the new side nav definition with the selected app items
    updateSideNavDefinition({
      searchApps: getSelectedAppItems(navItems)
    });
  }, [navItems, getSelectedAppItems, updateSideNavDefinition]);
  (0, _react.useEffect)(() => {
    return () => {
      updateSideNavDefinition({
        searchApps: undefined
      });
    };
  }, [updateSideNavDefinition]);
  return /*#__PURE__*/_react.default.createElement(_layout.EnterpriseSearchPageTemplateWrapper, (0, _extends2.default)({}, pageTemplateProps, {
    solutionNav: {
      items: chromeStyle === 'classic' ? navItems : undefined,
      name: _constants.SEARCH_PRODUCT_NAME
    },
    restrictWidth: restrictWidth,
    setPageChrome: pageChrome && /*#__PURE__*/_react.default.createElement(_kibana_chrome.SetEnterpriseSearchApplicationsChrome, {
      trail: pageChrome,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 101,
        columnNumber: 36
      }
    }),
    useEndpointHeaderActions: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 94,
      columnNumber: 5
    }
  }), pageViewTelemetry && /*#__PURE__*/_react.default.createElement(_telemetry.SendEnterpriseSearchTelemetry, {
    action: "viewed",
    metric: pageViewTelemetry,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 105,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_maintenance_mode_callout.MaintenanceModeCallout, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 107,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 108,
      columnNumber: 7
    }
  }), children);
};
exports.EnterpriseSearchApplicationsPageTemplate = EnterpriseSearchApplicationsPageTemplate;