"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GenerateAnalyticsApiKeyModal = void 0;
var _react = _interopRequireWildcard(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _generate_analytics_api_key_logic = require("../../../../api/generate_analytics_api_key/generate_analytics_api_key_logic");
var _generate_analytics_api_key_modal = require("./generate_analytics_api_key_modal.logic");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765022786381327106/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/search/plugins/enterprise_search/public/applications/analytics/components/analytics_collection_view/analytics_collection_integrate/api_key_modal/generate_analytics_api_key_modal.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const GenerateAnalyticsApiKeyModal = ({
  collectionName,
  onClose
}) => {
  const {
    keyName,
    apiKey,
    isLoading,
    isSuccess
  } = (0, _kea.useValues)(_generate_analytics_api_key_modal.GenerateApiKeyModalLogic);
  const {
    setKeyName
  } = (0, _kea.useActions)(_generate_analytics_api_key_modal.GenerateApiKeyModalLogic);
  const {
    makeRequest
  } = (0, _kea.useActions)(_generate_analytics_api_key_logic.generateAnalyticsApiKeyLogic);
  const copyApiKeyRef = (0, _react.useRef)(null);
  const modalTitleId = (0, _eui.useGeneratedHtmlId)();
  (0, _react.useEffect)(() => {
    if (isSuccess) {
      var _copyApiKeyRef$curren;
      (_copyApiKeyRef$curren = copyApiKeyRef.current) === null || _copyApiKeyRef$curren === void 0 ? void 0 : _copyApiKeyRef$curren.focus();
    }
  }, [isSuccess]);
  (0, _react.useEffect)(() => {
    setKeyName(`${collectionName} API key`);
  }, [collectionName]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiModal, {
    onClose: onClose,
    "aria-labelledby": modalTitleId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 65,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeader, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 66,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeaderTitle, {
    id: modalTitleId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 67,
      columnNumber: 9
    }
  }, _i18n.i18n.translate('xpack.enterpriseSearch.content.analytics.api.generateAnalyticsApiKeyModal.title', {
    defaultMessage: 'Create analytics API Key'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiModalBody, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 76,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasShadow: false,
    color: !isSuccess ? 'primary' : 'success',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 78,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 79,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 80,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    alignItems: "flexEnd",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 81,
      columnNumber: 17
    }
  }, !isSuccess ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 84,
      columnNumber: 23
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.enterpriseSearch.content.analytics.api.generateAnalyticsApiKeyModal.nameYourAPIKeyLabel",
      defaultMessage: "Name your API key",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 87,
        columnNumber: 29
      }
    }),
    fullWidth: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 85,
      columnNumber: 25
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    "data-test-subj": "enterpriseSearchGenerateAnalyticsApiKeyModalFieldText",
    "data-telemetry-id": "entSearchContent-analyticss-api-generateAnalyticsApiKeyModal-editName",
    fullWidth: true,
    placeholder: "Type a name for your API key",
    onChange: event => setKeyName(event.currentTarget.value),
    value: keyName,
    isLoading: isLoading,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 94,
      columnNumber: 27
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 106,
      columnNumber: 23
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-telemetry-id": "entSearchContent-analyticss-api-generateAnalyticsApiKeyModal-generateApiKeyButton",
    "data-test-subj": "generateApiKeyButton",
    iconSide: "left",
    iconType: "plusInCircle",
    fill: true,
    onClick: () => {
      makeRequest({
        collectionName,
        keyName: keyName.trim()
      });
    },
    disabled: keyName.trim().length <= 0,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 107,
      columnNumber: 25
    }
  }, _i18n.i18n.translate('xpack.enterpriseSearch.content.analytics.api.generateAnalyticsApiKeyModal.generateButton', {
    defaultMessage: 'Generate key'
  })))) : /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 131,
      columnNumber: 21
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    announceOnMount: true,
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.enterpriseSearch.content.analytics.api.generateAnalyticsApiKeyModal.callOutMessage",
      defaultMessage: "Done! The {name} API key was generated.",
      values: {
        name: /*#__PURE__*/_react.default.createElement("strong", {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 139,
            columnNumber: 37
          }
        }, keyName)
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 135,
        columnNumber: 27
      }
    }),
    color: "success",
    iconType: "check",
    role: "alert",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 132,
      columnNumber: 23
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 147,
      columnNumber: 23
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 148,
      columnNumber: 25
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
    "aria-label": keyName,
    fontSize: "m",
    paddingSize: "m",
    color: "dark",
    isCopyable: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 149,
      columnNumber: 27
    }
  }, apiKey)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 159,
      columnNumber: 25
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    buttonRef: copyApiKeyRef,
    "data-test-subj": "enterpriseSearchGenerateAnalyticsApiKeyModalButton",
    "data-telemetry-id": "entSearchContent-analyticss-api-generateAnalyticsApiKeyModal-csvDownloadButton",
    "aria-label": _i18n.i18n.translate('xpack.enterpriseSearch.content.analytics.api.generateAnalyticsApiKeyModal.csvDownloadButton', {
      defaultMessage: 'Download API key'
    }),
    iconType: "download",
    href: encodeURI(`data:text/csv;charset=utf-8,${apiKey}`),
    download: `${keyName}.csv`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 160,
      columnNumber: 27
    }
  })))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 178,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 179,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 180,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    color: "#006bb8",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 181,
      columnNumber: 21
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 182,
      columnNumber: 23
    }
  }, _i18n.i18n.translate('xpack.enterpriseSearch.content.analytics.api.generateAnalyticsApiKeyModal.apiKeyWarning', {
    defaultMessage: "Elastic does not store API keys. Once generated, you'll only be able to view the key one time. Make sure you save it somewhere secure. If you lose access to it you'll need to generate a new API key from this screen."
  })))))))))), /*#__PURE__*/_react.default.createElement(_eui.EuiModalFooter, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 199,
      columnNumber: 7
    }
  }, apiKey ? /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "enterpriseSearchGenerateAnalyticsApiKeyModalDoneButton",
    "data-telemetry-id": "entSearchContent-analyticss-api-generateAnalyticsApiKeyModal-done",
    fill: true,
    onClick: onClose,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 201,
      columnNumber: 11
    }
  }, _i18n.i18n.translate('xpack.enterpriseSearch.content.analytics.api.generateAnalyticsApiKeyModal.done', {
    defaultMessage: 'Done'
  })) : /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "enterpriseSearchGenerateAnalyticsApiKeyModalCancelButton",
    "data-telemetry-id": "entSearchContent-analyticss-api-generateAnalyticsApiKeyModal-cancel",
    onClick: onClose,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 215,
      columnNumber: 11
    }
  }, _i18n.i18n.translate('xpack.enterpriseSearch.content.analytics.api.generateAnalyticsApiKeyModal.cancel', {
    defaultMessage: 'Cancel'
  }))));
};
exports.GenerateAnalyticsApiKeyModal = GenerateAnalyticsApiKeyModal;