"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.hasEnterpriseLicense = hasEnterpriseLicense;
exports.hasGoldLicense = hasGoldLicense;
exports.hasPlatinumLicense = hasPlatinumLicense;
exports.isTrialLicense = isTrialLicense;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/* hasEnterpriseLicense return if the given license is an active `enterprise` or greater license
 */
function hasEnterpriseLicense(license) {
  if (license === undefined || license === null) return false;
  if (!license.isAvailable) return false;
  if (!license.isActive) return false;
  return license.hasAtLeast('enterprise');
}

/* hasPlatinumLicense return if the given license is an active `platinum` or greater license
 */
function hasPlatinumLicense(license) {
  if (license === undefined || license === null) return false;
  if (!license.isAvailable) return false;
  if (!license.isActive) return false;
  return license.hasAtLeast('platinum');
}

/* hasGoldLicense return if the given license is an active `gold` or greater license
 */
function hasGoldLicense(license) {
  if (license === undefined || license === null) return false;
  if (!license.isAvailable) return false;
  if (!license.isActive) return false;
  return license.hasAtLeast('gold');
}

/* isTrialLicense returns if the given license is an active `trial` license
 */
function isTrialLicense(license) {
  if (license === undefined || license === null) return false;
  if (!license.isAvailable) return false;
  if (!license.isActive) return false;
  return (license === null || license === void 0 ? void 0 : license.type) === 'trial';
}