"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getKibanaFeatureFlags = void 0;
var _elasticAssistantCommon = require("@kbn/elastic-assistant-common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic   License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getKibanaFeatureFlags = async context => {
  const {
    featureFlags
  } = await context.core;
  const attackDiscoveryPublicApiEnabled = await featureFlags.getBooleanValue(_elasticAssistantCommon.ATTACK_DISCOVERY_PUBLIC_API_ENABLED_FEATURE_FLAG, true);
  return {
    attackDiscoveryPublicApiEnabled
  };
};
exports.getKibanaFeatureFlags = getKibanaFeatureFlags;