"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.selectTab = exports.selectRecentlyClosedTabs = exports.selectIsTabsBarHidden = exports.selectAllTabs = void 0;
var _toolkit = require("@reduxjs/toolkit");
var _types = require("../types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const selectTab = (state, tabId) => {
  var _state$tabs$byId$tabI;
  return (_state$tabs$byId$tabI = state.tabs.byId[tabId]) !== null && _state$tabs$byId$tabI !== void 0 ? _state$tabs$byId$tabI : state.tabs.recentlyClosedTabsById[tabId];
};
exports.selectTab = selectTab;
const selectAllTabs = exports.selectAllTabs = (0, _toolkit.createSelector)([state => state.tabs.allIds, state => state.tabs.byId], (allIds, byId) => allIds.map(id => byId[id]));
const selectRecentlyClosedTabs = exports.selectRecentlyClosedTabs = (0, _toolkit.createSelector)([state => state.tabs.recentlyClosedTabIds, state => state.tabs.recentlyClosedTabsById], (recentlyClosedTabIds, byId) => recentlyClosedTabIds.map(id => byId[id]));
const selectIsTabsBarHidden = exports.selectIsTabsBarHidden = (0, _toolkit.createSelector)(state => state.tabsBarVisibility, tabsBarVisibility => tabsBarVisibility === _types.TabsBarVisibility.hidden);