"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useQualityIssues = useQualityIssues;
var _i18n = require("@kbn/i18n");
var _react = require("@xstate/react");
var _lodash = require("lodash");
var _react2 = _interopRequireWildcard(require("react"));
var _constants = require("../../common/constants");
var _translations = require("../../common/translations");
var _utils = require("../utils");
var _use_dataset_quality_details_state = require("./use_dataset_quality_details_state");
var _columns = require("../components/dataset_quality_details/quality_issue_flyout/failed_docs/columns");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765022786381327106/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/dataset_quality/public/hooks/use_quality_issues.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function useQualityIssues() {
  var _filteredItems$length, _failedDocsErrorsData;
  const {
    service
  } = (0, _use_dataset_quality_details_state.useDatasetQualityDetailsState)();
  const {
    services: {
      fieldFormats
    }
  } = (0, _utils.useKibanaContextForPlugin)();
  const {
    qualityIssues,
    expandedQualityIssue: expandedDegradedField,
    selectedIssueTypes,
    selectedFields,
    failedDocsErrors
  } = (0, _react.useSelector)(service, state => state.context);
  const {
    data,
    table
  } = qualityIssues !== null && qualityIssues !== void 0 ? qualityIssues : {};
  const {
    page,
    rowsPerPage,
    sort
  } = table;
  const {
    data: failedDocsErrorsData,
    table: failedDocsErrorsTable
  } = failedDocsErrors !== null && failedDocsErrors !== void 0 ? failedDocsErrors : {};
  const {
    page: failedDocsErrorsPage,
    rowsPerPage: failedDocsErrorsRowsPerPage,
    sort: failedDocsErrorsSort
  } = failedDocsErrorsTable;
  const filteredItems = (0, _react2.useMemo)(() => {
    if (!data) return [];
    return data.filter(item => (selectedIssueTypes.length === 0 || selectedIssueTypes.includes(item.type)) && (selectedFields.length === 0 || selectedFields.includes(item.name)));
  }, [data, selectedIssueTypes, selectedFields]);
  const totalItemCount = (_filteredItems$length = filteredItems === null || filteredItems === void 0 ? void 0 : filteredItems.length) !== null && _filteredItems$length !== void 0 ? _filteredItems$length : 0;
  const pagination = {
    pageIndex: page,
    pageSize: rowsPerPage,
    totalItemCount,
    hidePerPageOptions: true
  };
  const onTableChange = (0, _react2.useCallback)(options => {
    var _options$sort, _options$sort2;
    service.send({
      type: 'UPDATE_QUALITY_ISSUES_TABLE_CRITERIA',
      quality_issues_criteria: {
        page: options.page.index,
        rowsPerPage: options.page.size,
        sort: {
          field: ((_options$sort = options.sort) === null || _options$sort === void 0 ? void 0 : _options$sort.field) || _constants.DEFAULT_QUALITY_ISSUE_SORT_FIELD,
          direction: ((_options$sort2 = options.sort) === null || _options$sort2 === void 0 ? void 0 : _options$sort2.direction) || _constants.DEFAULT_QUALITY_ISSUE_SORT_DIRECTION
        }
      }
    });
  }, [service]);
  const renderedItems = (0, _react2.useMemo)(() => {
    const sortedItems = (0, _lodash.orderBy)(filteredItems, sort.field, sort.direction);
    return sortedItems.slice(page * rowsPerPage, (page + 1) * rowsPerPage);
  }, [filteredItems, sort.field, sort.direction, page, rowsPerPage]);
  const expandedRenderedItem = (0, _react2.useMemo)(() => {
    return renderedItems.find(item => item.name === (expandedDegradedField === null || expandedDegradedField === void 0 ? void 0 : expandedDegradedField.name) && item.type === (expandedDegradedField === null || expandedDegradedField === void 0 ? void 0 : expandedDegradedField.type));
  }, [expandedDegradedField, renderedItems]);
  const isFailedDocsErrorsLoading = (0, _react.useSelector)(service, state => {
    return state.matches('initializing.qualityIssueFlyout.open.failedDocsFlyout.fetching');
  });
  const isDegradedFieldsLoading = (0, _react.useSelector)(service, state => state.matches('initializing.dataStreamSettings.fetchingDataStreamSettings') || state.matches('initializing.dataStreamSettings.qualityIssues.dataStreamDegradedFields.fetchingDataStreamDegradedFields'));
  const closeDegradedFieldFlyout = (0, _react2.useCallback)(() => service.send({
    type: 'CLOSE_DEGRADED_FIELD_FLYOUT'
  }), [service]);
  const openDegradedFieldFlyout = (0, _react2.useCallback)((fieldName, qualityIssueType) => {
    if ((expandedDegradedField === null || expandedDegradedField === void 0 ? void 0 : expandedDegradedField.name) === fieldName && (expandedDegradedField === null || expandedDegradedField === void 0 ? void 0 : expandedDegradedField.type) === qualityIssueType) {
      service.send({
        type: 'CLOSE_DEGRADED_FIELD_FLYOUT'
      });
    } else {
      service.send({
        type: 'OPEN_QUALITY_ISSUE_FLYOUT',
        qualityIssue: {
          name: fieldName,
          type: qualityIssueType
        }
      });
    }
  }, [expandedDegradedField, service]);
  const degradedFieldValues = (0, _react.useSelector)(service, state => state.matches('initializing.qualityIssueFlyout.open.degradedFieldFlyout.ignoredValues.done') ? state.context.degradedFieldValues : undefined);
  const degradedFieldAnalysis = (0, _react.useSelector)(service, state => state.matches('initializing.qualityIssueFlyout.open.degradedFieldFlyout.mitigation.analyzed') || state.matches('initializing.qualityIssueFlyout.open.degradedFieldFlyout.mitigation.mitigating') || state.matches('initializing.qualityIssueFlyout.open.degradedFieldFlyout.mitigation.askingForRollover') || state.matches('initializing.qualityIssueFlyout.open.degradedFieldFlyout.mitigation.rollingOver') || state.matches('initializing.qualityIssueFlyout.open.degradedFieldFlyout.mitigation.success') || state.matches('initializing.qualityIssueFlyout.open.degradedFieldFlyout.mitigation.error') ? state.context.degradedFieldAnalysis : undefined);
  const degradedFieldAnalysisFormattedResult = (0, _react2.useMemo)(() => {
    if (!degradedFieldAnalysis) {
      return undefined;
    }

    // 1st check if it's a field limit issue
    if (degradedFieldAnalysis.isFieldLimitIssue) {
      return {
        potentialCause: _translations.degradedFieldCauseFieldLimitExceeded,
        tooltipContent: _translations.degradedFieldCauseFieldLimitExceededTooltip,
        shouldDisplayIgnoredValuesAndLimit: false,
        identifiedUsingHeuristics: true
      };
    }

    // 2nd check if it's a ignored above issue
    const fieldMapping = degradedFieldAnalysis.fieldMapping;
    if (fieldMapping && (fieldMapping === null || fieldMapping === void 0 ? void 0 : fieldMapping.type) === 'keyword' && fieldMapping !== null && fieldMapping !== void 0 && fieldMapping.ignore_above) {
      const isAnyValueExceedingIgnoreAbove = degradedFieldValues === null || degradedFieldValues === void 0 ? void 0 : degradedFieldValues.values.some(value => value.length > fieldMapping.ignore_above);
      if (isAnyValueExceedingIgnoreAbove) {
        return {
          potentialCause: _translations.degradedFieldCauseFieldIgnored,
          tooltipContent: _translations.degradedFieldCauseFieldIgnoredTooltip,
          shouldDisplayIgnoredValuesAndLimit: true,
          identifiedUsingHeuristics: true
        };
      }
    }

    // 3rd check if its a ignore_malformed issue. There is no check, at the moment.
    return {
      potentialCause: _translations.degradedFieldCauseFieldMalformed,
      tooltipContent: _translations.degradedFieldCauseFieldMalformedTooltip,
      shouldDisplayIgnoredValuesAndLimit: false,
      identifiedUsingHeuristics: false // TODO: Add heuristics to identify ignore_malformed issues
    };
  }, [degradedFieldAnalysis, degradedFieldValues]);
  const isDegradedFieldsValueLoading = (0, _react.useSelector)(service, state => {
    return state.matches('initializing.qualityIssueFlyout.open.degradedFieldFlyout.ignoredValues.fetching');
  });
  const isRolloverRequired = (0, _react.useSelector)(service, state => {
    return state.matches('initializing.qualityIssueFlyout.open.degradedFieldFlyout.mitigation.askingForRollover');
  });
  const isMitigationAppliedSuccessfully = (0, _react.useSelector)(service, state => {
    return state.matches('initializing.qualityIssueFlyout.open.degradedFieldFlyout.mitigation.success');
  });
  const isAnalysisInProgress = (0, _react.useSelector)(service, state => {
    return state.matches('initializing.qualityIssueFlyout.open.degradedFieldFlyout.mitigation.analyzing');
  });
  const isRolloverInProgress = (0, _react.useSelector)(service, state => {
    return state.matches('initializing.qualityIssueFlyout.open.degradedFieldFlyout.mitigation.rollingOver');
  });
  const updateNewFieldLimit = (0, _react2.useCallback)(newFieldLimit => {
    service.send({
      type: 'SET_NEW_FIELD_LIMIT',
      newFieldLimit
    });
  }, [service]);
  const isMitigationInProgress = (0, _react.useSelector)(service, state => {
    return state.matches('initializing.qualityIssueFlyout.open.degradedFieldFlyout.mitigation.mitigating');
  });
  const newFieldLimitData = (0, _react.useSelector)(service, state => state.matches('initializing.qualityIssueFlyout.open.degradedFieldFlyout.mitigation.success') || state.matches('initializing.qualityIssueFlyout.open.degradedFieldFlyout.mitigation.error') ? state.context.fieldLimit : undefined);
  const triggerRollover = (0, _react2.useCallback)(() => {
    service.send('ROLLOVER_DATA_STREAM');
  }, [service]);
  const failedDocsErrorsColumns = (0, _react2.useMemo)(() => (0, _columns.getFailedDocsErrorsColumns)(), []);
  const renderedFailedDocsErrorsItems = (0, _react2.useMemo)(() => {
    const sortedItems = (0, _lodash.orderBy)(failedDocsErrorsData, failedDocsErrorsSort.field, failedDocsErrorsSort.direction);
    return sortedItems.slice(failedDocsErrorsPage * failedDocsErrorsRowsPerPage, (failedDocsErrorsPage + 1) * failedDocsErrorsRowsPerPage);
  }, [failedDocsErrorsData, failedDocsErrorsSort.field, failedDocsErrorsSort.direction, failedDocsErrorsPage, failedDocsErrorsRowsPerPage]);
  const onFailedDocsErrorsTableChange = (0, _react2.useCallback)(options => {
    var _options$sort3, _options$sort4;
    service.send({
      type: 'UPDATE_FAILED_DOCS_ERRORS_TABLE_CRITERIA',
      failed_docs_errors_criteria: {
        page: options.page.index,
        rowsPerPage: options.page.size,
        sort: {
          field: ((_options$sort3 = options.sort) === null || _options$sort3 === void 0 ? void 0 : _options$sort3.field) || _constants.DEFAULT_FAILED_DOCS_ERROR_SORT_FIELD,
          direction: ((_options$sort4 = options.sort) === null || _options$sort4 === void 0 ? void 0 : _options$sort4.direction) || _constants.DEFAULT_FAILED_DOCS_ERROR_SORT_DIRECTION
        }
      }
    });
  }, [service]);
  const failedDocsErrorsPagination = {
    pageIndex: failedDocsErrorsPage,
    pageSize: failedDocsErrorsRowsPerPage,
    totalItemCount: (_failedDocsErrorsData = failedDocsErrorsData === null || failedDocsErrorsData === void 0 ? void 0 : failedDocsErrorsData.length) !== null && _failedDocsErrorsData !== void 0 ? _failedDocsErrorsData : 0,
    hidePerPageOptions: true
  };
  const resultsCount = (0, _react2.useMemo)(() => {
    const startNumberItemsOnPage = failedDocsErrorsRowsPerPage * failedDocsErrorsPage + (renderedFailedDocsErrorsItems.length ? 1 : 0);
    const endNumberItemsOnPage = failedDocsErrorsRowsPerPage * failedDocsErrorsPage + renderedFailedDocsErrorsItems.length;
    return failedDocsErrorsRowsPerPage === 0 ? /*#__PURE__*/_react2.default.createElement("strong", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 320,
        columnNumber: 7
      }
    }, _i18n.i18n.translate('xpack.datasetQuality.resultsCount.strong.lllLabel', {
      defaultMessage: 'lll'
    })) : /*#__PURE__*/_react2.default.createElement(_react2.default.Fragment, null, /*#__PURE__*/_react2.default.createElement("strong", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 327,
        columnNumber: 9
      }
    }, startNumberItemsOnPage, "-", endNumberItemsOnPage), ' ', ' of ', " ", failedDocsErrorsData === null || failedDocsErrorsData === void 0 ? void 0 : failedDocsErrorsData.length);
  }, [failedDocsErrorsRowsPerPage, failedDocsErrorsPage, renderedFailedDocsErrorsItems.length, failedDocsErrorsData === null || failedDocsErrorsData === void 0 ? void 0 : failedDocsErrorsData.length]);
  return {
    isDegradedFieldsLoading,
    pagination,
    onTableChange,
    renderedItems,
    sort: {
      sort
    },
    fieldFormats,
    totalItemCount,
    expandedDegradedField,
    openDegradedFieldFlyout,
    closeDegradedFieldFlyout,
    degradedFieldValues,
    isDegradedFieldsValueLoading,
    isAnalysisInProgress,
    degradedFieldAnalysis,
    degradedFieldAnalysisFormattedResult,
    expandedRenderedItem,
    updateNewFieldLimit,
    isMitigationInProgress,
    isRolloverInProgress,
    newFieldLimitData,
    isRolloverRequired,
    isMitigationAppliedSuccessfully,
    triggerRollover,
    renderedFailedDocsErrorsItems,
    failedDocsErrorsSort: {
      sort: failedDocsErrorsSort
    },
    resultsCount,
    failedDocsErrorsColumns,
    isFailedDocsErrorsLoading,
    failedDocsErrorsPagination,
    onFailedDocsErrorsTableChange
  };
}