"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DataStreamNotFoundPrompt = DataStreamNotFoundPrompt;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765022786381327106/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/dataset_quality/public/components/dataset_quality_details/index_not_found_prompt.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const emptyPromptTitle = _i18n.i18n.translate('xpack.datasetQuality.details.emptypromptTitle', {
  defaultMessage: 'Unable to load your data stream'
});
const emptyPromptBody = dataStream => _i18n.i18n.translate('xpack.datasetQuality.details.emptyPromptBody', {
  defaultMessage: 'Data stream not found: {dataStream}',
  values: {
    dataStream
  }
});
function DataStreamNotFoundPrompt({
  dataStream
}) {
  const promptTitle = /*#__PURE__*/_react.default.createElement("h2", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 25,
      columnNumber: 23
    }
  }, emptyPromptTitle);
  const promptBody = /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    "data-test-subj": "datasetQualityDetailsEmptyPromptBody",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 27,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 28,
      columnNumber: 7
    }
  }, emptyPromptBody(dataStream)));
  return /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    iconType: "error",
    color: "danger",
    title: promptTitle,
    body: promptBody,
    "data-test-subj": "datasetQualityDetailsEmptyPrompt",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 33,
      columnNumber: 5
    }
  });
}