"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EventRateChart = void 0;
var _react = _interopRequireWildcard(require("react"));
var _charts = require("@elastic/charts");
var _eui = require("@elastic/eui");
var _chartsTheme = require("@kbn/charts-theme");
var _i18n = require("@kbn/i18n");
var _axes = require("./axes");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765022786381327106/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/data_visualizer/public/application/file_data_visualizer/new/doc_count_chart/event_rate_chart.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const EventRateChart = ({
  eventRateChartData,
  height,
  width
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const chartBaseTheme = (0, _chartsTheme.useElasticChartsTheme)();
  const theme = (0, _react.useMemo)(() => ({
    scales: {
      histogramPadding: 0.2
    },
    background: {
      color: 'transparent'
    },
    axes: {
      gridLine: {
        horizontal: {
          stroke: euiTheme.colors.lightShade
        },
        vertical: {
          stroke: euiTheme.colors.lightShade
        }
      }
    }
  }), [euiTheme]);
  return /*#__PURE__*/_react.default.createElement("div", {
    style: {
      width,
      height
    },
    "data-test-subj": `dataVisualizerEventRateChart ${eventRateChartData.length ? 'withData' : 'empty'}`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 61,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_charts.Chart, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 67,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_axes.Axes, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 68,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_charts.Tooltip, {
    type: _charts.TooltipType.None,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 69,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_charts.Settings, {
    theme: theme,
    locale: _i18n.i18n.getLocale(),
    baseTheme: chartBaseTheme,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 70,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_charts.HistogramBarSeries, {
    id: "event_rate"
    // Defaults to multi layer time axis as of Elastic Charts v70
    ,
    xScaleType: _charts.ScaleType.Time,
    yScaleType: _charts.ScaleType.Linear,
    xAccessor: 'time',
    yAccessors: ['value'],
    data: eventRateChartData
    // Amsterdam + Borealis
    ,
    color: euiTheme.colors.vis.euiColorVis0,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 72,
      columnNumber: 9
    }
  })));
};
exports.EventRateChart = EventRateChart;