"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MetricDistributionChartTooltipHeader = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _utils = require("../../../utils");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765022786381327106/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/data_visualizer/public/application/common/components/stats_table/components/metric_distribution_chart/metric_distribution_chart_tooltip_header.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const MetricDistributionChartTooltipHeader = ({
  chartPoint,
  maxWidth,
  fieldFormat
}) => {
  if (chartPoint === undefined) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement("div", {
    style: {
      maxWidth
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 32,
      columnNumber: 5
    }
  }, chartPoint.dataMax > chartPoint.dataMin ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.dataVisualizer.dataGrid.field.metricDistributionChart.tooltipValueBetweenLabel",
    defaultMessage: "{percent}% of documents have values between {minValFormatted} and {maxValFormatted}",
    values: {
      percent: chartPoint.percent,
      minValFormatted: (0, _utils.kibanaFieldFormat)(chartPoint.dataMin, fieldFormat),
      maxValFormatted: (0, _utils.kibanaFieldFormat)(chartPoint.dataMax, fieldFormat)
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 34,
      columnNumber: 9
    }
  }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.dataVisualizer.dataGrid.field.metricDistributionChart.tooltipValueEqualLabel",
    defaultMessage: "{percent}% of documents have a value of {valFormatted}",
    values: {
      percent: chartPoint.percent,
      valFormatted: (0, _utils.kibanaFieldFormat)(chartPoint.dataMin, fieldFormat)
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 44,
      columnNumber: 9
    }
  }));
};
exports.MetricDistributionChartTooltipHeader = MetricDistributionChartTooltipHeader;