"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IndexBasedNumberContentPreview = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _metric_distribution_chart = require("../metric_distribution_chart");
var _utils = require("../../../utils");
var _column_chart_styles = require("./column_chart_styles");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765022786381327106/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/data_visualizer/public/application/common/components/stats_table/components/field_data_row/number_content_preview.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const METRIC_DISTRIBUTION_CHART_WIDTH = 100;
const METRIC_DISTRIBUTION_CHART_HEIGHT = 10;
const IndexBasedNumberContentPreview = ({
  config
}) => {
  const styles = (0, _column_chart_styles.useColumnChartStyles)();
  const {
    stats,
    fieldFormat,
    fieldName
  } = config;
  const dataTestSubj = `dataVisualizerDataGridChart-${fieldName}`;
  const distributionChartData = (0, _react.useMemo)(() => (0, _metric_distribution_chart.buildChartDataFromStats)(stats === null || stats === void 0 ? void 0 : stats.distribution, METRIC_DISTRIBUTION_CHART_WIDTH), [stats === null || stats === void 0 ? void 0 : stats.distribution]);
  const legendText = (0, _react.useMemo)(() => Array.isArray(distributionChartData) && distributionChartData[0].x !== undefined && distributionChartData[distributionChartData.length - 1].x !== undefined ? {
    min: (0, _utils.formatSingleValue)(distributionChartData[0].x),
    max: (0, _utils.formatSingleValue)(distributionChartData[distributionChartData.length - 1].x)
  } : '', [distributionChartData]);
  return /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": dataTestSubj,
    style: {
      width: '100%'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 47,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    css: styles.histogram,
    "data-test-subj": `${dataTestSubj}-histogram`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 48,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_metric_distribution_chart.MetricDistributionChart, {
    width: METRIC_DISTRIBUTION_CHART_WIDTH,
    height: METRIC_DISTRIBUTION_CHART_HEIGHT,
    chartData: distributionChartData,
    fieldFormat: fieldFormat,
    hideXAxis: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 49,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement("div", {
    css: styles.legend,
    "data-test-subj": `${dataTestSubj}-legend`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 57,
      columnNumber: 7
    }
  }, legendText && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: 'row',
    "data-test-subj": `${dataTestSubj}-legend`,
    responsive: false,
    gutterSize: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 60,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    style: {
      maxWidth: METRIC_DISTRIBUTION_CHART_WIDTH * 0.75
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 66,
      columnNumber: 15
    }
  }, (0, _utils.kibanaFieldFormat)(legendText.min, fieldFormat)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 69,
      columnNumber: 15
    }
  }, (0, _utils.kibanaFieldFormat)(legendText.max, fieldFormat))))));
};
exports.IndexBasedNumberContentPreview = IndexBasedNumberContentPreview;