"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ScriptedFieldsTable = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _scripting_languages = require("../../../scripting_languages");
var _components = require("./components");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765022786381327106/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/data_view_management/public/components/edit_index_pattern/scripted_fields_table/scripted_fields_table.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
class ScriptedFieldsTable extends _react.Component {
  constructor(props) {
    super(props);
    (0, _defineProperty2.default)(this, "fetchFields", async () => {
      const fields = this.props.indexPattern.getScriptedFields();
      const deprecatedLangsInUse = [];
      const deprecatedLangs = (0, _scripting_languages.getDeprecatedScriptingLanguages)();
      const supportedLangs = (0, _scripting_languages.getSupportedScriptingLanguages)();
      for (const field of fields) {
        const lang = field.lang;
        if (lang && (deprecatedLangs.includes(lang) || !supportedLangs.includes(lang))) {
          deprecatedLangsInUse.push(lang);
        }
      }
      this.setState({
        fields,
        deprecatedLangsInUse
      });
    });
    (0, _defineProperty2.default)(this, "getFilteredItems", () => {
      const {
        fields
      } = this.state;
      const {
        fieldFilter,
        scriptedFieldLanguageFilter,
        userEditPermission
      } = this.props;
      let languageFilteredFields = fields;
      if (scriptedFieldLanguageFilter.length) {
        languageFilteredFields = fields.filter(field => scriptedFieldLanguageFilter.includes(field.lang));
      }
      let filteredFields = languageFilteredFields;
      if (fieldFilter) {
        const normalizedFieldFilter = fieldFilter.toLowerCase();
        filteredFields = languageFilteredFields.filter(field => field.name.toLowerCase().includes(normalizedFieldFilter));
      }
      filteredFields.forEach(field => field.isUserEditable = userEditPermission);
      return filteredFields;
    });
    (0, _defineProperty2.default)(this, "startDeleteField", field => {
      this.setState({
        fieldToDelete: field,
        isDeleteConfirmationModalVisible: true
      });
    });
    (0, _defineProperty2.default)(this, "hideDeleteConfirmationModal", () => {
      this.setState({
        fieldToDelete: undefined,
        isDeleteConfirmationModalVisible: false
      });
    });
    (0, _defineProperty2.default)(this, "deleteField", () => {
      const {
        indexPattern,
        onRemoveField,
        saveIndexPattern
      } = this.props;
      const {
        fieldToDelete
      } = this.state;
      indexPattern.removeScriptedField(fieldToDelete.name);
      saveIndexPattern(indexPattern);
      if (onRemoveField) {
        onRemoveField();
      }
      this.fetchFields();
      this.hideDeleteConfirmationModal();
    });
    this.state = {
      deprecatedLangsInUse: [],
      fieldToDelete: undefined,
      isDeleteConfirmationModalVisible: false,
      fields: []
    };
  }
  UNSAFE_componentWillMount() {
    this.fetchFields();
  }
  render() {
    const {
      indexPattern,
      painlessDocLink
    } = this.props;
    const {
      fieldToDelete,
      deprecatedLangsInUse
    } = this.state;
    const items = this.getFilteredItems();
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_components.Header, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 139,
        columnNumber: 9
      }
    }), /*#__PURE__*/_react.default.createElement(_components.CallOuts, {
      deprecatedLangsInUse: deprecatedLangsInUse,
      painlessDocLink: painlessDocLink,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 141,
        columnNumber: 9
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "l",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 143,
        columnNumber: 9
      }
    }), /*#__PURE__*/_react.default.createElement(_components.Table, {
      indexPattern: indexPattern,
      items: items,
      editField: field => this.props.helpers.redirectToRoute(field),
      deleteField: this.startDeleteField,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 145,
        columnNumber: 9
      }
    }), fieldToDelete && /*#__PURE__*/_react.default.createElement(_components.DeleteScritpedFieldConfirmationModal, {
      deleteField: this.deleteField,
      field: fieldToDelete,
      hideDeleteConfirmationModal: this.hideDeleteConfirmationModal,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 153,
        columnNumber: 11
      }
    }));
  }
}
exports.ScriptedFieldsTable = ScriptedFieldsTable;