"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ChartsFilter = void 0;
var _fp = require("lodash/fp");
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _use_test_id_generator = require("../../../hooks/use_test_id_generator");
var _rest_types = require("../../../../common/rest_types");
var _translations = require("../../../translations");
var _charts_filter_popover = require("./charts_filter_popover");
var _toggle_all_button = require("./toggle_all_button");
var _hooks = require("../../hooks");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765022786381327106/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/data_usage/public/app/components/filters/charts_filter.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const getSearchPlaceholder = filterName => {
  if (filterName === 'dataStreams') {
    return _translations.UX_LABELS.filterSearchPlaceholder('data streams');
  }
  return _translations.UX_LABELS.filterSearchPlaceholder('metric types');
};
const ChartsFilter = exports.ChartsFilter = /*#__PURE__*/(0, _react.memo)(({
  filterOptions: {
    filterName,
    options,
    appendOptions,
    selectedOptions,
    onChangeFilterOptions,
    isFilterLoading = false
  },
  'data-test-subj': dataTestSubj
}) => {
  const getTestId = (0, _use_test_id_generator.useTestIdGenerator)(dataTestSubj);
  const isMetricsFilter = filterName === 'metricTypes';
  const isDataStreamsFilter = filterName === 'dataStreams';

  // popover states and handlers
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react.useState)(false);
  const onPopoverButtonClick = (0, _react.useCallback)(() => {
    setIsPopoverOpen(!isPopoverOpen);
  }, [setIsPopoverOpen, isPopoverOpen]);
  const onClosePopover = (0, _react.useCallback)(() => {
    setIsPopoverOpen(false);
  }, [setIsPopoverOpen]);
  const {
    areDataStreamsSelectedOnMount,
    items,
    setItems,
    hasActiveFilters,
    numActiveFilters,
    numFilters,
    setAreDataStreamsSelectedOnMount,
    setUrlDataStreamsFilter,
    setUrlMetricTypesFilter
  } = (0, _hooks.useChartsFilter)({
    filterOptions: {
      filterName,
      options,
      appendOptions,
      selectedOptions,
      onChangeFilterOptions,
      isFilterLoading
    }
  });
  const isSelectAllDisabled = (0, _react.useMemo)(() => options.length === 0 || hasActiveFilters && numFilters === 0, [hasActiveFilters, numFilters, options.length]);
  const addHeightToPopover = (0, _react.useMemo)(() => isDataStreamsFilter && numFilters + numActiveFilters > 15, [isDataStreamsFilter, numFilters, numActiveFilters]);

  // track popover state to pin selected options
  const wasPopoverOpen = (0, _react.useRef)(isPopoverOpen);

  // compute if selected dataStreams should be pinned
  const shouldPinSelectedDataStreams = (0, _react.useCallback)((isNotChangingOptions = true) => {
    // case 1: when no dataStreams are selected initially
    return isNotChangingOptions && wasPopoverOpen.current && isPopoverOpen && filterName === 'dataStreams';
  }, [filterName, isPopoverOpen]);

  // augmented options based on the dataStreams filter
  const sortedDataStreamsFilterOptions = (0, _react.useMemo)(() => {
    if (shouldPinSelectedDataStreams() || areDataStreamsSelectedOnMount) {
      // pin checked items to the top
      const sorted = (0, _fp.orderBy)('checked', 'asc', items.filter(item => !item.isGroupLabel));
      return [...items.filter(item => item.isGroupLabel), ...sorted];
    }
    // return options as are for other filters
    return items;
  }, [areDataStreamsSelectedOnMount, shouldPinSelectedDataStreams, items]);
  const isSearchable = (0, _react.useMemo)(() => !isMetricsFilter, [isMetricsFilter]);
  const onOptionsChange = (0, _react.useCallback)(newOptions => {
    const optionItemsToSet = newOptions.map(option => option);

    // update filter UI options state
    setItems(optionItemsToSet);

    // compute a selected list of options
    const selectedItems = newOptions.reduce((acc, curr) => {
      if (curr.checked === 'on' && curr.key) {
        acc.push(curr.key);
      }
      return acc;
    }, []);

    // update URL params
    if (isMetricsFilter) {
      setUrlMetricTypesFilter(selectedItems.join(','));
    } else if (isDataStreamsFilter) {
      setUrlDataStreamsFilter(selectedItems.join(','));
    }
    // reset shouldPinSelectedDataStreams, setAreDataStreamsSelectedOnMount
    shouldPinSelectedDataStreams(false);
    setAreDataStreamsSelectedOnMount(false);
    onChangeFilterOptions(selectedItems);
  }, [setItems, isMetricsFilter, isDataStreamsFilter, shouldPinSelectedDataStreams, setAreDataStreamsSelectedOnMount, onChangeFilterOptions, setUrlMetricTypesFilter, setUrlDataStreamsFilter]);
  const onSelectAll = (0, _react.useCallback)(() => {
    const allItems = items.reduce((acc, item) => {
      if (!item.isGroupLabel) {
        acc.push({
          ...item,
          checked: 'on'
        });
      } else {
        acc.push(item);
      }
      return acc;
    }, []);
    setItems(allItems);
    const optionsToSelect = allItems.reduce((acc, i) => {
      if (i.checked) {
        acc.push(i.label);
      }
      return acc;
    }, []);
    onChangeFilterOptions(optionsToSelect);
    if (isDataStreamsFilter) {
      setUrlDataStreamsFilter(optionsToSelect.join(','));
    }
    if (isMetricsFilter) {
      setUrlMetricTypesFilter(optionsToSelect.map(option => _rest_types.METRIC_TYPE_UI_OPTIONS_VALUES_TO_API_MAP[option]).join(','));
    }
  }, [items, isDataStreamsFilter, isMetricsFilter, setItems, onChangeFilterOptions, setUrlDataStreamsFilter, setUrlMetricTypesFilter]);
  const onClearAll = (0, _react.useCallback)(() => {
    setItems(items.map(item => {
      return {
        ...item,
        checked: undefined
      };
    }));
    onChangeFilterOptions([]);
    if (isDataStreamsFilter) {
      setUrlDataStreamsFilter('');
    }
    if (isMetricsFilter) {
      setUrlMetricTypesFilter('');
    }
  }, [items, isDataStreamsFilter, isMetricsFilter, setItems, onChangeFilterOptions, setUrlDataStreamsFilter, setUrlMetricTypesFilter]);
  (0, _react.useEffect)(() => {
    return () => {
      wasPopoverOpen.current = isPopoverOpen;
    };
  }, [isPopoverOpen, wasPopoverOpen]);
  return /*#__PURE__*/_react.default.createElement(_charts_filter_popover.ChartsFilterPopover, {
    closePopover: onClosePopover,
    filterName: filterName,
    hasActiveFilters: hasActiveFilters,
    isPopoverOpen: isPopoverOpen,
    numActiveFilters: numActiveFilters,
    numFilters: numFilters,
    onButtonClick: onPopoverButtonClick,
    "data-test-subj": dataTestSubj,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 243,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelectable, {
    "aria-label": `${filterName}`,
    emptyMessage: _translations.UX_LABELS.filterEmptyMessage(filterName),
    height: addHeightToPopover ? 380 : undefined,
    isLoading: isFilterLoading,
    onChange: onOptionsChange,
    options: sortedDataStreamsFilterOptions,
    searchable: isSearchable ? true : undefined,
    searchProps: {
      placeholder: getSearchPlaceholder(filterName),
      compressed: true
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 253,
      columnNumber: 9
    }
  }, (list, search) => {
    return /*#__PURE__*/_react.default.createElement("div", {
      style: {
        width: 300
      },
      "data-test-subj": getTestId(`${filterName}-popoverList`),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 268,
        columnNumber: 15
      }
    }, isSearchable && /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverTitle, {
      "data-test-subj": getTestId(`${filterName}-search`),
      paddingSize: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 270,
        columnNumber: 19
      }
    }, search), list, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "none",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 278,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: 1,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 279,
        columnNumber: 19
      }
    }, /*#__PURE__*/_react.default.createElement(_toggle_all_button.ToggleAllButton, {
      color: "primary",
      "data-test-subj": getTestId(`${filterName}-selectAllButton`),
      icon: "check",
      label: _translations.UX_LABELS.filterSelectAll,
      isDisabled: isSelectAllDisabled,
      onClick: onSelectAll,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 280,
        columnNumber: 21
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: 1,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 289,
        columnNumber: 19
      }
    }, /*#__PURE__*/_react.default.createElement(_toggle_all_button.ToggleAllButton, {
      color: "danger",
      "data-test-subj": getTestId(`${filterName}-clearAllButton`),
      icon: "cross",
      label: _translations.UX_LABELS.filterClearAll,
      isDisabled: !hasActiveFilters,
      onClick: onClearAll,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 290,
        columnNumber: 21
      }
    }))));
  }));
});
ChartsFilter.displayName = 'ChartsFilter';