"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CopyToDashboardAction = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireDefault(require("react"));
var _presentationPublishing = require("@kbn/presentation-publishing");
var _reactKibanaMount = require("@kbn/react-kibana-mount");
var _public = require("@kbn/ui-actions-plugin/public");
var _types = require("../dashboard_api/types");
var _kibana_services = require("../services/kibana_services");
var _get_dashboard_capabilities = require("../utils/get_dashboard_capabilities");
var _dashboard_actions_strings = require("./_dashboard_actions_strings");
var _copy_to_dashboard_modal = require("./copy_to_dashboard_modal");
var _constants = require("./constants");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765022786381327106/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/dashboard/public/dashboard_actions/copy_to_dashboard_action.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
const apiIsCompatible = api => {
  var _api$parentApi;
  return (0, _presentationPublishing.apiHasUniqueId)(api) && (0, _presentationPublishing.apiHasParentApi)(api) && (0, _presentationPublishing.apiIsOfType)(api.parentApi, _types.DASHBOARD_API_TYPE) && (api === null || api === void 0 ? void 0 : (_api$parentApi = api.parentApi) === null || _api$parentApi === void 0 ? void 0 : _api$parentApi.getDashboardPanelFromId) !== undefined && (0, _presentationPublishing.apiPublishesSavedObjectId)(api.parentApi);
};
class CopyToDashboardAction {
  constructor() {
    (0, _defineProperty2.default)(this, "type", _constants.ACTION_COPY_TO_DASHBOARD);
    (0, _defineProperty2.default)(this, "id", _constants.ACTION_COPY_TO_DASHBOARD);
    (0, _defineProperty2.default)(this, "order", 1);
    (0, _defineProperty2.default)(this, "grouping", [_constants.DASHBOARD_ACTION_GROUP]);
  }
  getDisplayName({
    embeddable
  }) {
    if (!apiIsCompatible(embeddable)) throw new _public.IncompatibleActionError();
    return _dashboard_actions_strings.dashboardCopyToDashboardActionStrings.getDisplayName();
  }
  getIconType({
    embeddable
  }) {
    if (!apiIsCompatible(embeddable)) throw new _public.IncompatibleActionError();
    return 'exit';
  }
  async isCompatible({
    embeddable
  }) {
    if (!apiIsCompatible(embeddable)) return false;
    const {
      createNew: canCreateNew,
      showWriteControls: canEditExisting
    } = (0, _get_dashboard_capabilities.getDashboardCapabilities)();
    return Boolean(canCreateNew || canEditExisting);
  }
  async execute({
    embeddable
  }) {
    if (!apiIsCompatible(embeddable)) throw new _public.IncompatibleActionError();
    const session = _kibana_services.coreServices.overlays.openModal((0, _reactKibanaMount.toMountPoint)(/*#__PURE__*/_react.default.createElement(_copy_to_dashboard_modal.CopyToDashboardModal, {
      closeModal: () => session.close(),
      api: embeddable,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 88,
        columnNumber: 9
      }
    }), _kibana_services.coreServices), {
      maxWidth: 400,
      'data-test-subj': 'copyToDashboardPanel'
    });
  }
}
exports.CopyToDashboardAction = CopyToDashboardAction;