"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SimpleDebugOverlay = void 0;
var _react = _interopRequireWildcard(require("react"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765022786381327106/elastic/kibana-artifacts-snapshot/kibana/src/core/packages/chrome/layout/core-chrome-layout-components/debug/simple_debug_overlay.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/**
 * A minimal debug component for temporary overlays (sidebar, footer, banner, etc.)
 * Fills its parent container, with customizable background and text.
 *
 * @param props - {@link SimpleDebugOverlayProps}
 * @returns The rendered debug overlay.
 */

const SimpleDebugOverlay = ({
  label = 'Debug Overlay',
  background = '#e6f4ff',
  color = '#0099ff',
  style = {},
  children
}) => {
  const containerRef = (0, _react.useRef)(null);
  const [isVertical, setIsVertical] = (0, _react.useState)(false);
  (0, _react.useLayoutEffect)(() => {
    const handleResize = () => {
      if (containerRef.current) {
        const width = containerRef.current.offsetWidth;
        setIsVertical(width > 0 && width < 200);
      }
    };
    handleResize();
    window.addEventListener('resize', handleResize);
    return () => window.removeEventListener('resize', handleResize);
  }, []);
  return /*#__PURE__*/_react.default.createElement("div", {
    ref: containerRef,
    style: {
      width: '100%',
      height: '100%',
      background,
      color,
      display: 'flex',
      alignItems: 'center',
      justifyContent: 'center',
      fontFamily: 'monospace',
      fontSize: 16,
      border: '2px dashed #0099ff',
      boxSizing: 'border-box',
      ...style
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 51,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement("span", {
    style: isVertical ? {
      writingMode: 'vertical-rl',
      textOrientation: 'mixed',
      whiteSpace: 'nowrap'
    } : {},
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 68,
      columnNumber: 7
    }
  }, children || label));
};
exports.SimpleDebugOverlay = SimpleDebugOverlay;