"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EsEventStreamClientFactory = void 0;
var _es_event_stream_client = require("./es_event_stream_client");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

class EsEventStreamClientFactory {
  constructor(deps) {
    this.deps = deps;
  }
  create(core) {
    const startServices = core.getStartServices();
    return new _es_event_stream_client.EsEventStreamClient({
      ...this.deps,
      esClient: startServices.then(([{
        elasticsearch
      }]) => elasticsearch.client.asInternalUser)
    });
  }
}
exports.EsEventStreamClientFactory = EsEventStreamClientFactory;