"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Container = Container;
var _react = _interopRequireDefault(require("react"));
var _reactRedux = require("react-redux");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react2 = require("@emotion/react");
var _palette_selector = require("../palette_selector/palette_selector");
var _color_mapping = require("../../state/color_mapping");
var _selectors = require("../../state/selectors");
var _gradient = require("../palette_selector/gradient");
var _scale = require("../palette_selector/scale");
var _unassigned_terms_config = require("./unassigned_terms_config");
var _assignments = require("./assignments");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765022786381327106/elastic/kibana-artifacts-snapshot/kibana/src/platform/packages/shared/kbn-coloring/src/shared_components/color_mapping/components/container/container.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function Container({
  data,
  palettes,
  isDarkMode,
  specialTokens,
  formatter,
  allowCustomMatch
}) {
  const dispatch = (0, _reactRedux.useDispatch)();
  const palette = (0, _reactRedux.useSelector)((0, _selectors.selectPalette)(palettes));
  const colorMode = (0, _reactRedux.useSelector)(_selectors.selectColorMode);
  const assignments = (0, _reactRedux.useSelector)(_selectors.selectComputedAssignments);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "m",
    justifyContent: "flexStart",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 49,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 50,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    alignItems: "center",
    justifyContent: "spaceBetween",
    gutterSize: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 51,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 57,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_palette_selector.PaletteSelector, {
    palettes: palettes,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 58,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 0,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 60,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_scale.ScaleMode, {
    palettes: palettes,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 61,
      columnNumber: 13
    }
  })))), colorMode.type === 'gradient' && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    style: {
      position: 'relative'
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 66,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    css: (0, _react2.css)`
              position: absolute;
              right: 0;
            }`,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 67,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    position: "top",
    content: _i18n.i18n.translate('coloring.colorMapping.container.invertGradientButtonLabel', {
      defaultMessage: 'Invert gradient'
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 73,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    "data-test-subj": "lns-colorMapping-invertGradient",
    color: "text",
    iconType: "merge",
    size: "xs",
    "aria-label": _i18n.i18n.translate('coloring.colorMapping.container.invertGradientButtonLabel', {
      defaultMessage: 'Invert gradient'
    }),
    onClick: () => {
      dispatch((0, _color_mapping.changeGradientSortOrder)(colorMode.sort === 'asc' ? 'desc' : 'asc'));
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 79,
      columnNumber: 15
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: _i18n.i18n.translate('coloring.colorMapping.container.gradientHeader', {
      defaultMessage: 'Gradient'
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 96,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_gradient.Gradient, {
    colorMode: colorMode,
    palettes: palettes,
    isDarkMode: isDarkMode,
    paletteId: palette.id,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 102,
      columnNumber: 13
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 112,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: _i18n.i18n.translate('coloring.colorMapping.container.mappingAssignmentHeader', {
      defaultMessage: 'Color assignments'
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 113,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_assignments.Assignments, {
    isDarkMode: isDarkMode,
    data: data,
    palettes: palettes,
    specialTokens: specialTokens,
    formatter: formatter,
    allowCustomMatch: allowCustomMatch,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 119,
      columnNumber: 11
    }
  }))), assignments.length > 0 && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 130,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_unassigned_terms_config.UnassignedTermsConfig, {
    data: data,
    isDarkMode: isDarkMode,
    palettes: palettes,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 131,
      columnNumber: 11
    }
  })));
}