"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LatestFindingsContainer = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _cloudSecurityPostureCommon = require("@kbn/cloud-security-posture-common");
var _constants = require("../../../common/constants");
var _empty_state = require("../../../components/empty_state");
var _cloud_security_grouping = require("../../../components/cloud_security_grouping");
var _findings_search_bar = require("../layout/findings_search_bar");
var _use_latest_findings_grouping = require("./use_latest_findings_grouping");
var _latest_findings_table = require("./latest_findings_table");
var _latest_findings_group_renderer = require("./latest_findings_group_renderer");
var _error_callout = require("../layout/error_callout");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765022786381327106/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/cloud_security_posture/public/pages/configurations/latest_findings/latest_findings_container.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const SubGrouping = ({
  renderChildComponent,
  groupingLevel,
  parentGroupFilters,
  selectedGroup,
  groupSelectorComponent
}) => {
  const {
    groupData,
    grouping,
    isFetching,
    activePageIndex,
    pageSize,
    onChangeGroupsItemsPerPage,
    onChangeGroupsPage,
    isGroupLoading,
    setActivePageIndex
  } = (0, _use_latest_findings_grouping.useLatestFindingsGrouping)({
    groupPanelRenderer: _latest_findings_group_renderer.groupPanelRenderer,
    getGroupStats: _latest_findings_group_renderer.groupStatsRenderer,
    groupingLevel,
    selectedGroup,
    groupFilters: parentGroupFilters ? JSON.parse(parentGroupFilters) : []
  });

  /**
   * This is used to reset the active page index when the selected group changes
   * It is needed because the grouping number of pages can change according to the selected group
   */
  (0, _react.useEffect)(() => {
    setActivePageIndex(0);
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [selectedGroup]);
  return /*#__PURE__*/_react.default.createElement(_cloud_security_grouping.CloudSecurityGrouping, {
    data: groupData,
    grouping: grouping,
    renderChildComponent: renderChildComponent,
    onChangeGroupsItemsPerPage: onChangeGroupsItemsPerPage,
    onChangeGroupsPage: onChangeGroupsPage,
    activePageIndex: activePageIndex,
    isFetching: isFetching,
    pageSize: pageSize,
    selectedGroup: selectedGroup,
    isGroupLoading: isGroupLoading,
    groupingLevel: groupingLevel,
    groupSelectorComponent: groupSelectorComponent,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 61,
      columnNumber: 5
    }
  });
};
const LatestFindingsContainer = () => {
  const {
    grouping,
    isFetching,
    urlQuery,
    setUrlQuery,
    onResetFilters,
    error,
    isEmptyResults
  } = (0, _use_latest_findings_grouping.useLatestFindingsGrouping)({
    groupPanelRenderer: _latest_findings_group_renderer.groupPanelRenderer,
    getGroupStats: _latest_findings_group_renderer.groupStatsRenderer
  });
  const renderChildComponent = ({
    level,
    currentSelectedGroup,
    selectedGroupOptions,
    parentGroupFilters,
    groupSelectorComponent
  }) => {
    let getChildComponent;
    if (currentSelectedGroup === 'none') {
      return /*#__PURE__*/_react.default.createElement(_latest_findings_table.LatestFindingsTable, {
        groupSelectorComponent: groupSelectorComponent,
        nonPersistedFilters: [...(parentGroupFilters ? JSON.parse(parentGroupFilters) : [])],
        showDistributionBar: selectedGroupOptions.includes('none'),
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 99,
          columnNumber: 9
        }
      });
    }
    if (level < selectedGroupOptions.length - 1 && !selectedGroupOptions.includes('none')) {
      getChildComponent = currentGroupFilters => {
        const nextGroupingLevel = level + 1;
        return renderChildComponent({
          level: nextGroupingLevel,
          currentSelectedGroup: selectedGroupOptions[nextGroupingLevel],
          selectedGroupOptions,
          parentGroupFilters: JSON.stringify([...currentGroupFilters, ...(parentGroupFilters ? JSON.parse(parentGroupFilters) : [])]),
          groupSelectorComponent
        });
      };
    } else {
      getChildComponent = currentGroupFilters => {
        return /*#__PURE__*/_react.default.createElement(_latest_findings_table.LatestFindingsTable, {
          nonPersistedFilters: [...currentGroupFilters, ...(parentGroupFilters ? JSON.parse(parentGroupFilters) : [])],
          height: _constants.DEFAULT_GROUPING_TABLE_HEIGHT,
          showDistributionBar: selectedGroupOptions.includes('none'),
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 124,
            columnNumber: 11
          }
        });
      };
    }
    return /*#__PURE__*/_react.default.createElement(SubGrouping, {
      renderChildComponent: getChildComponent,
      selectedGroup: selectedGroupOptions[level],
      groupingLevel: level,
      parentGroupFilters: parentGroupFilters,
      groupSelectorComponent: groupSelectorComponent,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 136,
        columnNumber: 7
      }
    });
  };
  if (error || isEmptyResults) {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_findings_search_bar.FindingsSearchBar, {
      query: urlQuery,
      setQuery: setUrlQuery,
      loading: isFetching,
      refreshQueryKey: _cloudSecurityPostureCommon.CDR_MISCONFIGURATIONS_INDEX_PATTERN,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 149,
        columnNumber: 9
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 155,
        columnNumber: 9
      }
    }), error && /*#__PURE__*/_react.default.createElement(_error_callout.ErrorCallout, {
      error: error,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 156,
        columnNumber: 19
      }
    }), isEmptyResults && /*#__PURE__*/_react.default.createElement(_empty_state.EmptyState, {
      onResetFilters: onResetFilters,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 157,
        columnNumber: 28
      }
    }));
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_findings_search_bar.FindingsSearchBar, {
    query: urlQuery,
    setQuery: setUrlQuery,
    loading: isFetching,
    refreshQueryKey: _cloudSecurityPostureCommon.CDR_MISCONFIGURATIONS_INDEX_PATTERN,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 164,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement("div", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 170,
      columnNumber: 7
    }
  }, renderChildComponent({
    level: 0,
    currentSelectedGroup: grouping.selectedGroups[0],
    selectedGroupOptions: grouping.selectedGroups,
    groupSelectorComponent: grouping.groupSelector
  })));
};
exports.LatestFindingsContainer = LatestFindingsContainer;