"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Edit = void 0;
var _react = _interopRequireDefault(require("react"));
var _hook_form_lib = require("@kbn/es-ui-shared-plugin/static/forms/hook_form_lib");
var _components = require("@kbn/es-ui-shared-plugin/static/forms/components");
var _eui = require("@elastic/eui");
var _domain = require("../../../../common/types/domain");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765022786381327106/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/cases/public/components/custom_fields/toggle/edit.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const EditComponent = ({
  customField,
  customFieldConfiguration,
  onSubmit,
  isLoading,
  canUpdate
}) => {
  const initialValue = Boolean(customField === null || customField === void 0 ? void 0 : customField.value);
  const title = customFieldConfiguration.label;
  const {
    form
  } = (0, _hook_form_lib.useForm)({
    defaultValue: {
      value: initialValue
    }
  });
  const onSubmitCustomField = async () => {
    const {
      isValid,
      data
    } = await form.submit();
    if (isValid) {
      var _customField$key;
      onSubmit({
        ...customField,
        key: (_customField$key = customField === null || customField === void 0 ? void 0 : customField.key) !== null && _customField$key !== void 0 ? _customField$key : customFieldConfiguration.key,
        type: _domain.CustomFieldTypes.TOGGLE,
        value: data.value
      });
    }
  };
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "none",
    justifyContent: "spaceBetween",
    responsive: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 46,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 52,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 53,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("h4", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 54,
      columnNumber: 13
    }
  }, title)))), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 58,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "m",
    "data-test-subj": `case-toggle-custom-field-${customFieldConfiguration.key}`,
    direction: "column",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 59,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_hook_form_lib.Form, {
    form: form,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 64,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_hook_form_lib.UseField, {
    path: "value",
    component: _components.ToggleField,
    onChange: onSubmitCustomField,
    componentProps: {
      euiFieldProps: {
        disabled: isLoading || !canUpdate,
        'data-test-subj': `case-toggle-custom-field-form-field-${customFieldConfiguration.key}`
      }
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 65,
      columnNumber: 11
    }
  }))));
};
EditComponent.displayName = 'Edit';
const Edit = exports.Edit = /*#__PURE__*/_react.default.memo(EditComponent);