"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PageManager = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var pageActions = _interopRequireWildcard(require("../../state/actions/pages"));
var _app = require("../../state/selectors/app");
var _workpad = require("../../state/selectors/workpad");
var _constants = require("../../../common/lib/constants");
var _page_manager = require("./page_manager.component");
var _workpad2 = require("../../routes/workpad");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765022786381327106/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/canvas/public/components/page_manager/page_manager.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
// @ts-expect-error untyped local
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const PageManager = ({
  onPreviousPage
}) => {
  const dispatch = (0, _reactRedux.useDispatch)();
  const propsFromState = (0, _reactRedux.useSelector)(state => ({
    isWriteable: (0, _workpad.isWriteable)(state) && (0, _app.canUserWrite)(state),
    pages: (0, _workpad.getPages)(state),
    selectedPage: (0, _workpad.getSelectedPage)(state),
    workpadId: (0, _workpad.getWorkpad)(state).id,
    workpadCSS: (0, _workpad.getWorkpad)(state).css || _constants.DEFAULT_WORKPAD_CSS
  }));
  const {
    gotoPage
  } = (0, _react.useContext)(_workpad2.WorkpadRoutingContext);
  const onAddPage = (0, _react.useCallback)(() => dispatch(pageActions.addPage({
    gotoPage
  })), [dispatch, gotoPage]);
  const onMovePage = (0, _react.useCallback)((id, position) => dispatch(pageActions.movePage(id, position, gotoPage)), [dispatch, gotoPage]);
  const onRemovePage = (0, _react.useCallback)(id => dispatch(pageActions.removePage({
    id,
    gotoPage
  })), [dispatch, gotoPage]);
  return /*#__PURE__*/_react.default.createElement(_page_manager.PageManager, (0, _extends2.default)({
    onPreviousPage: onPreviousPage,
    onAddPage: onAddPage,
    onMovePage: onMovePage,
    onRemovePage: onRemovePage
  }, propsFromState, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 48,
      columnNumber: 5
    }
  }));
};
exports.PageManager = PageManager;