"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DurationDistributionChart = DurationDistributionChart;
exports.replaceHistogramZerosWithMinimumDomainValue = void 0;
var _react = _interopRequireWildcard(require("react"));
var _lodash = require("lodash");
var _charts = require("@elastic/charts");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/observability-shared-plugin/public");
var _common = require("@kbn/observability-plugin/common");
var _formatters = require("../../../../../common/utils/formatters");
var _constants = require("../../../../../common/correlations/constants");
var _chart_container = require("../chart_container");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765022786381327106/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/components/shared/charts/duration_distribution_chart/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const NUMBER_OF_TRANSACTIONS_LABEL = _i18n.i18n.translate('xpack.apm.durationDistribution.chart.numberOfTransactionsLabel', {
  defaultMessage: 'Transactions'
});
const NUMBER_OF_SPANS_LABEL = _i18n.i18n.translate('xpack.apm.durationDistribution.chart.numberOfSpansLabel', {
  defaultMessage: 'Spans'
});
const getAnnotationsStyle = (color = 'gray') => ({
  line: {
    strokeWidth: 1,
    stroke: color,
    opacity: 0.8
  }
});

// With a log based y axis in combination with the `CURVE_STEP_AFTER` style,
// the line of an area would not go down to 0 but end on the y axis at the last value >0.
// By replacing the 0s with a small value >0 the line will be drawn as intended.
// This is just to visually fix the line, for tooltips, that number will be again rounded down to 0.
// Note this workaround is only safe to use for this type of chart because it works with
// count based values and not a float based metric for example on the y axis.
const Y_AXIS_MIN_DOMAIN = 0.5;
const Y_AXIS_MIN_VALUE = 0.0001;
const replaceHistogramZerosWithMinimumDomainValue = histogramItems => histogramItems.reduce((histogramItem, _, i) => {
  if (histogramItem[i].doc_count === 0) {
    histogramItem[i].doc_count = Y_AXIS_MIN_VALUE;
  }
  return histogramItem;
}, histogramItems);

// Create and call a duration formatter for every value since the durations for the
// x axis might have a wide range of values e.g. from low milliseconds to large seconds.
// This way we can get different suitable units across ticks.
exports.replaceHistogramZerosWithMinimumDomainValue = replaceHistogramZerosWithMinimumDomainValue;
const xAxisTickFormat = d => (0, _formatters.getDurationFormatter)(d, 0.9999)(d).formatted;
function DurationDistributionChart({
  data,
  hasData,
  markerCurrentEvent,
  markerValue,
  onChartSelection,
  selection,
  status,
  eventType
}) {
  var _Math$max;
  const chartThemes = (0, _public.useChartThemes)();
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const markerPercentile = _constants.DEFAULT_PERCENTILE_THRESHOLD;
  const annotationsDataValues = [{
    dataValue: markerValue,
    details: _i18n.i18n.translate('xpack.apm.durationDistribution.chart.percentileMarkerLabel', {
      defaultMessage: '{markerPercentile}th percentile',
      values: {
        markerPercentile
      }
    })
  }];

  // This will create y axis ticks for 1, 10, 100, 1000 ...
  const yMax = (_Math$max = Math.max(...(0, _lodash.flatten)(data.map(d => d.histogram)).map(d => d.doc_count))) !== null && _Math$max !== void 0 ? _Math$max : 0;
  const yTicks = Math.max(1, Math.ceil(Math.log10(yMax)));
  const yAxisMaxDomain = Math.pow(10, yTicks);
  const yAxisDomain = {
    min: Y_AXIS_MIN_DOMAIN,
    max: yAxisMaxDomain
  };
  const selectionAnnotation = selection !== undefined ? [{
    coordinates: {
      x0: selection[0],
      x1: selection[1],
      y0: 0,
      y1: yAxisMaxDomain
    },
    details: 'selection'
  }] : undefined;
  const chartData = (0, _react.useMemo)(() => data.map(d => ({
    ...d,
    histogram: replaceHistogramZerosWithMinimumDomainValue(d.histogram)
  })), [data]);
  return /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "apmCorrelationsChart",
    style: {
      overflow: 'hidden',
      textOverflow: 'ellipsis'
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 162,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_chart_container.ChartContainer, {
    height: 250,
    hasData: hasData,
    status: status,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 166,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_charts.Chart, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 167,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_charts.Settings, {
    rotation: 0,
    theme: [{
      legend: {
        spacingBuffer: 100
      },
      areaSeriesStyle: {
        line: {
          visible: true
        },
        point: {
          visible: 'never',
          radius: 0
        }
      },
      axes: {
        tickLine: {
          visible: true,
          size: 5,
          padding: 10
        },
        tickLabel: {
          fontSize: 10,
          fill: euiTheme.colors.mediumShade,
          padding: 0
        }
      }
    }, ...chartThemes.theme],
    baseTheme: chartThemes.baseTheme,
    showLegend: true,
    legendPosition: _charts.Position.Bottom,
    onBrushEnd: onChartSelection,
    locale: _i18n.i18n.getLocale(),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 168,
      columnNumber: 11
    }
  }), selectionAnnotation !== undefined && /*#__PURE__*/_react.default.createElement(_charts.RectAnnotation, {
    dataValues: selectionAnnotation,
    id: "rect_annotation_1",
    style: {
      strokeWidth: 1,
      stroke: euiTheme.colors.lightShade,
      fill: euiTheme.colors.lightShade,
      opacity: 0.9
    },
    hideTooltips: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 206,
      columnNumber: 13
    }
  }), typeof markerCurrentEvent === 'number' && /*#__PURE__*/_react.default.createElement(_charts.LineAnnotation, {
    id: "annotation_current_event",
    domainType: _charts.AnnotationDomainType.XDomain,
    dataValues: [{
      dataValue: markerCurrentEvent,
      details: _i18n.i18n.translate('xpack.apm.durationDistribution.chart.currentEventMarkerLabel', {
        defaultMessage: 'Current sample'
      })
    }],
    style: getAnnotationsStyle((0, _eui.euiPaletteColorBlind)()[0]),
    marker: _i18n.i18n.translate('xpack.apm.durationDistribution.chart.currentEventMarkerLabel', {
      defaultMessage: 'Current sample'
    }),
    markerPosition: 'bottom',
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 219,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_charts.LineAnnotation, {
    id: "apmCorrelationsChartPercentileAnnotation",
    domainType: _charts.AnnotationDomainType.XDomain,
    dataValues: annotationsDataValues,
    style: getAnnotationsStyle(),
    marker: `${markerPercentile}p`,
    markerPosition: 'top',
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 243,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_charts.Axis, {
    id: "x-axis",
    title: _i18n.i18n.translate('xpack.apm.durationDistribution.chart.latencyLabel', {
      defaultMessage: 'Latency'
    }),
    position: _charts.Position.Bottom,
    tickFormat: xAxisTickFormat,
    gridLine: {
      visible: false
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 251,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_charts.Axis, {
    id: "y-axis",
    domain: yAxisDomain,
    title: eventType === _common.ProcessorEvent.transaction ? NUMBER_OF_TRANSACTIONS_LABEL : NUMBER_OF_SPANS_LABEL,
    position: _charts.Position.Left,
    ticks: yTicks,
    gridLine: {
      visible: true
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 260,
      columnNumber: 11
    }
  }), chartData.map(d => /*#__PURE__*/_react.default.createElement(_charts.AreaSeries, {
    key: d.id,
    id: d.id,
    xScaleType: _charts.ScaleType.Log,
    yScaleType: _charts.ScaleType.Log,
    data: d.histogram,
    curve: _charts.CurveType.CURVE_STEP_AFTER,
    xAccessor: "key",
    yAccessors: ['doc_count'],
    color: d.areaSeriesColor,
    fit: "linear",
    areaSeriesStyle: {
      fit: {
        line: {
          visible: true
        }
      }
    }
    // To make the area appear with a continuous line,
    // we changed the original data to replace values of 0 with Y_AXIS_MIN_DOMAIN.
    // To show the correct values again in tooltips, we use a custom tickFormat to round values.
    // We can safely do this because all duration values above 0 are without decimal points anyway.
    ,
    tickFormat: p => `${Math.floor(p)}`,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 273,
      columnNumber: 13
    }
  })))));
}