"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WaterfallWithSummary = WaterfallWithSummary;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _transaction_summary = require("../../../shared/summary/transaction_summary");
var _transaction_action_menu = require("../../../shared/transaction_action_menu/transaction_action_menu");
var _maybe_view_trace_link = require("./maybe_view_trace_link");
var _transaction_tabs = require("./transaction_tabs");
var _use_fetcher = require("../../../../hooks/use_fetcher");
var _open_in_discover_button = require("../../../shared/links/discover_links/open_in_discover_button");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765022786381327106/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/components/app/transaction_details/waterfall_with_summary/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function WaterfallWithSummary({
  waterfallFetchResult,
  waterfallFetchStatus,
  traceSamples,
  traceSamplesFetchStatus,
  environment,
  onSampleClick,
  onTabClick,
  serviceName,
  waterfallItemId,
  detailTab,
  showCriticalPath,
  onShowCriticalPathChange,
  selectedSample
}) {
  var _waterfallFetchResult;
  const [sampleActivePage, setSampleActivePage] = (0, _react.useState)(0);
  const isControlled = selectedSample !== undefined;
  const isLoading = waterfallFetchStatus === _use_fetcher.FETCH_STATUS.LOADING || traceSamplesFetchStatus === _use_fetcher.FETCH_STATUS.LOADING;
  // When traceId is not present, call to waterfallFetchResult will not be initiated
  const isSucceeded = (waterfallFetchStatus === _use_fetcher.FETCH_STATUS.SUCCESS || waterfallFetchStatus === _use_fetcher.FETCH_STATUS.NOT_INITIATED) && traceSamplesFetchStatus === _use_fetcher.FETCH_STATUS.SUCCESS;
  (0, _react.useEffect)(() => {
    if (!isControlled) {
      setSampleActivePage(0);
    }
  }, [traceSamples, isControlled]);
  const goToSample = index => {
    const sample = traceSamples[index];
    if (!isControlled) {
      setSampleActivePage(index);
    }
    onSampleClick(sample);
  };
  const samplePageIndex = isControlled ? selectedSample ? traceSamples === null || traceSamples === void 0 ? void 0 : traceSamples.indexOf(selectedSample) : 0 : sampleActivePage;
  const {
    entryTransaction
  } = waterfallFetchResult;
  if (!entryTransaction && (traceSamples === null || traceSamples === void 0 ? void 0 : traceSamples.length) === 0 && isSucceeded) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
      title: /*#__PURE__*/_react.default.createElement("div", {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 99,
          columnNumber: 11
        }
      }, _i18n.i18n.translate('xpack.apm.transactionDetails.traceNotFound', {
        defaultMessage: 'The selected trace cannot be found'
      })),
      "data-test-subj": "apmNoTraceFound",
      titleSize: "s",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 97,
        columnNumber: 7
      }
    });
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 112,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 113,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 114,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 115,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 116,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement("h5", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 117,
      columnNumber: 15
    }
  }, _i18n.i18n.translate('xpack.apm.transactionDetails.traceSampleTitle', {
    defaultMessage: 'Trace sample'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 124,
      columnNumber: 11
    }
  }, !!(traceSamples !== null && traceSamples !== void 0 && traceSamples.length) && /*#__PURE__*/_react.default.createElement(_eui.EuiPagination, {
    pageCount: traceSamples.length,
    activePage: samplePageIndex,
    onPageClick: goToSample,
    compressed: true,
    "aria-label": _i18n.i18n.translate('xpack.apm.transactionDetails.traceSamplePaginationLabel', {
      defaultMessage: 'Trace sample pages'
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 126,
      columnNumber: 15
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 140,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexEnd",
    gutterSize: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 141,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 142,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_maybe_view_trace_link.MaybeViewTraceLink, {
    isLoading: isLoading,
    transaction: entryTransaction,
    waterfall: waterfallFetchResult,
    environment: environment,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 143,
      columnNumber: 17
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 150,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_open_in_discover_button.OpenInDiscoverButton, {
    dataTestSubj: "apmWaterfallOpenInDiscoverButton",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 151,
      columnNumber: 17
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 153,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_transaction_action_menu.TransactionActionMenu, {
    isLoading: isLoading,
    transaction: entryTransaction,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 154,
      columnNumber: 17
    }
  })))))), isLoading || !entryTransaction ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 162,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 163,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonText, {
    lines: 1,
    "data-test-sub": "loading-content",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 164,
      columnNumber: 11
    }
  })) : /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 167,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_transaction_summary.TransactionSummary, {
    errorCount: waterfallFetchResult.totalErrorsCount,
    totalDuration: (_waterfallFetchResult = waterfallFetchResult.rootWaterfallTransaction) === null || _waterfallFetchResult === void 0 ? void 0 : _waterfallFetchResult.duration,
    transaction: entryTransaction,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 168,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 176,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_transaction_tabs.TransactionTabs, {
    transaction: entryTransaction,
    detailTab: detailTab,
    serviceName: serviceName,
    waterfallItemId: waterfallItemId,
    onTabClick: onTabClick,
    waterfall: waterfallFetchResult,
    isLoading: isLoading,
    showCriticalPath: showCriticalPath,
    onShowCriticalPathChange: onShowCriticalPathChange,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 177,
      columnNumber: 9
    }
  })));
}