"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UPGRADE_TO_PLATINUM_SUBTITLE = exports.UPGRADE_TO_PLATINUM = exports.UPGRADE_SUBSCRIPTION = exports.UPCOMING = exports.UNARCHIVE_MODAL_TITLE = exports.UNARCHIVE_MODAL_SUBTITLE = exports.TABLE_STATUS_UPCOMING = exports.TABLE_STATUS_RUNNING = exports.TABLE_STATUS_FINISHED = exports.TABLE_STATUS_DISABLED = exports.TABLE_STATUS_ARCHIVED = exports.TABLE_STATUS = exports.TABLE_START_TIME = exports.TABLE_END_TIME = exports.TABLE_ALERTS_TOOLTIP = exports.TABLE_ALERTS = exports.TABLE_ACTION_UNARCHIVE = exports.TABLE_ACTION_EDIT = exports.TABLE_ACTION_DELETE = exports.TABLE_ACTION_CANCEL_AND_ARCHIVE = exports.TABLE_ACTION_CANCEL = exports.START_TRIAL = exports.SOLUTION_CONFIG_REMOVAL_WARNING_TITLE = exports.SOLUTION_CONFIG_REMOVAL_WARNING_SUBTITLE = exports.SEARCH_PLACEHOLDER = exports.SAVE_MAINTENANCE_WINDOW = exports.REFRESH = exports.READ_ONLY_BADGE_TOOLTIP = exports.READ_ONLY_BADGE_TEXT = exports.NAME = exports.MAINTENANCE_WINDOWS_RETURN_LINK = exports.MAINTENANCE_WINDOWS_DESCRIPTION = exports.MAINTENANCE_WINDOWS = exports.EMPTY_PROMPT_TITLE = exports.EMPTY_PROMPT_DOCUMENTATION = exports.EMPTY_PROMPT_DESCRIPTION = exports.EMPTY_PROMPT_BUTTON = exports.EDIT_MAINTENANCE_WINDOW = exports.DELETE_MODAL_TITLE = exports.DELETE_MODAL_SUBTITLE = exports.CREATE_NEW_BUTTON = exports.CREATE_MAINTENANCE_WINDOW_DESCRIPTION = exports.CREATE_MAINTENANCE_WINDOW = exports.CREATE_FORM_TIMEZONE = exports.CREATE_FORM_TIMEFRAME_TITLE = exports.CREATE_FORM_TIMEFRAME_DESCRIPTION = exports.CREATE_FORM_SOLUTION_STACK_RULES = exports.CREATE_FORM_SOLUTION_SELECTION_TITLE = exports.CREATE_FORM_SOLUTION_SELECTION_DESCRIPTION = exports.CREATE_FORM_SOLUTION_SELECTION_CHECKBOX_GROUP_TITLE = exports.CREATE_FORM_SOLUTION_SECURITY_RULES = exports.CREATE_FORM_SOLUTION_OBSERVABILITY_RULES = exports.CREATE_FORM_SCOPED_QUERY_TOGGLE_TITLE = exports.CREATE_FORM_SCOPED_QUERY_TITLE = exports.CREATE_FORM_SCOPED_QUERY_INVALID_ERROR_MESSAGE = exports.CREATE_FORM_SCOPED_QUERY_EMPTY_ERROR_MESSAGE = exports.CREATE_FORM_SCOPED_QUERY_DESCRIPTION = exports.CREATE_FORM_SCHEDULE_INVALID = exports.CREATE_FORM_SCHEDULE = exports.CREATE_FORM_REPEAT = exports.CREATE_FORM_RECURRING_SUMMARY_PREFIX = exports.CREATE_FORM_NAME_REQUIRED = exports.COPY_ID_ACTION_SUCCESS = exports.COPY_ID = exports.CANCEL_MODAL_TITLE = exports.CANCEL_MODAL_SUBTITLE = exports.CANCEL_MODAL_BUTTON = exports.CANCEL_AND_ARCHIVE_MODAL_TITLE = exports.CANCEL_AND_ARCHIVE_MODAL_SUBTITLE = exports.CANCEL = exports.ARCHIVE_TITLE = exports.ARCHIVE_SUBTITLE = exports.ARCHIVE_CALLOUT_SUBTITLE = exports.ARCHIVE = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MAINTENANCE_WINDOWS = exports.MAINTENANCE_WINDOWS = _i18n.i18n.translate('xpack.alerting.maintenanceWindows', {
  defaultMessage: 'Maintenance Windows'
});
const MAINTENANCE_WINDOWS_DESCRIPTION = exports.MAINTENANCE_WINDOWS_DESCRIPTION = _i18n.i18n.translate('xpack.alerting.maintenanceWindows.description', {
  defaultMessage: 'Suppress rule notifications for scheduled periods of time.'
});
const READ_ONLY_BADGE_TEXT = exports.READ_ONLY_BADGE_TEXT = _i18n.i18n.translate('xpack.alerting.maintenanceWindows.badge.readOnly.text', {
  defaultMessage: 'Read only'
});
const READ_ONLY_BADGE_TOOLTIP = exports.READ_ONLY_BADGE_TOOLTIP = _i18n.i18n.translate('xpack.alerting.maintenanceWindows.badge.readOnly.tooltip', {
  defaultMessage: 'Unable to create or edit maintenance Windows'
});
const CREATE_NEW_BUTTON = exports.CREATE_NEW_BUTTON = _i18n.i18n.translate('xpack.alerting.maintenanceWindows.createNewButton', {
  defaultMessage: 'Create window'
});
const EMPTY_PROMPT_BUTTON = exports.EMPTY_PROMPT_BUTTON = _i18n.i18n.translate('xpack.alerting.maintenanceWindows.emptyPrompt.button', {
  defaultMessage: 'Create a maintenance window'
});
const EMPTY_PROMPT_DOCUMENTATION = exports.EMPTY_PROMPT_DOCUMENTATION = _i18n.i18n.translate('xpack.alerting.maintenanceWindows.emptyPrompt.documentation', {
  defaultMessage: 'Documentation'
});
const EMPTY_PROMPT_TITLE = exports.EMPTY_PROMPT_TITLE = _i18n.i18n.translate('xpack.alerting.maintenanceWindows.emptyPrompt.title', {
  defaultMessage: 'Create your first maintenance window'
});
const EMPTY_PROMPT_DESCRIPTION = exports.EMPTY_PROMPT_DESCRIPTION = _i18n.i18n.translate('xpack.alerting.maintenanceWindows.emptyPrompt.description', {
  defaultMessage: 'Schedule a time period in which rule notifications cease.'
});
const CREATE_MAINTENANCE_WINDOW = exports.CREATE_MAINTENANCE_WINDOW = _i18n.i18n.translate('xpack.alerting.maintenanceWindows.create.maintenanceWindow', {
  defaultMessage: 'Create maintenance window'
});
const CREATE_MAINTENANCE_WINDOW_DESCRIPTION = exports.CREATE_MAINTENANCE_WINDOW_DESCRIPTION = _i18n.i18n.translate('xpack.alerting.maintenanceWindows.create.description', {
  defaultMessage: 'Schedule a single or recurring period in which new alerts do not send notifications.'
});
const MAINTENANCE_WINDOWS_RETURN_LINK = exports.MAINTENANCE_WINDOWS_RETURN_LINK = _i18n.i18n.translate('xpack.alerting.maintenanceWindows.returnLink', {
  defaultMessage: 'Return'
});
const NAME = exports.NAME = _i18n.i18n.translate('xpack.alerting.maintenanceWindows.name', {
  defaultMessage: 'Name'
});
const CREATE_FORM_NAME_REQUIRED = exports.CREATE_FORM_NAME_REQUIRED = _i18n.i18n.translate('xpack.alerting.maintenanceWindows.createForm.nameFieldRequiredError', {
  defaultMessage: 'A name is required.'
});
const CREATE_FORM_SCHEDULE = exports.CREATE_FORM_SCHEDULE = _i18n.i18n.translate('xpack.alerting.maintenanceWindows.createForm.schedule', {
  defaultMessage: 'Schedule'
});
const CREATE_FORM_SCHEDULE_INVALID = exports.CREATE_FORM_SCHEDULE_INVALID = _i18n.i18n.translate('xpack.alerting.maintenanceWindows.createForm.scheduleInvalid', {
  defaultMessage: 'The end date must be greater than or equal to the start date.'
});
const CREATE_FORM_TIMEZONE = exports.CREATE_FORM_TIMEZONE = _i18n.i18n.translate('xpack.alerting.maintenanceWindows.createForm.timezone', {
  defaultMessage: 'Time zone'
});
const CREATE_FORM_REPEAT = exports.CREATE_FORM_REPEAT = _i18n.i18n.translate('xpack.alerting.maintenanceWindows.createForm.repeat', {
  defaultMessage: 'Repeat'
});
const CREATE_FORM_TIMEFRAME_TITLE = exports.CREATE_FORM_TIMEFRAME_TITLE = _i18n.i18n.translate('xpack.alerting.maintenanceWindows.createForm.frequency.title', {
  defaultMessage: 'Timeframe'
});
const CREATE_FORM_TIMEFRAME_DESCRIPTION = exports.CREATE_FORM_TIMEFRAME_DESCRIPTION = _i18n.i18n.translate('xpack.alerting.maintenanceWindows.createForm.frequency.description', {
  defaultMessage: 'Define the start and end time when events should be affected by the window.'
});
const CREATE_FORM_SOLUTION_SELECTION_TITLE = exports.CREATE_FORM_SOLUTION_SELECTION_TITLE = _i18n.i18n.translate('xpack.alerting.maintenanceWindows.createForm.solutionSelection.title', {
  defaultMessage: 'Solution specific maintenance window'
});
const CREATE_FORM_SOLUTION_SELECTION_DESCRIPTION = exports.CREATE_FORM_SOLUTION_SELECTION_DESCRIPTION = _i18n.i18n.translate('xpack.alerting.maintenanceWindows.createForm.solutionSelection.description', {
  defaultMessage: 'Only rules associated with the selected solution are affected by the maintenance window.'
});
const CREATE_FORM_SOLUTION_SELECTION_CHECKBOX_GROUP_TITLE = exports.CREATE_FORM_SOLUTION_SELECTION_CHECKBOX_GROUP_TITLE = _i18n.i18n.translate('xpack.alerting.maintenanceWindows.createForm.solutionSelection.checkboxGroupTitle', {
  defaultMessage: 'Select the solution this should affect'
});
const CREATE_FORM_SOLUTION_OBSERVABILITY_RULES = exports.CREATE_FORM_SOLUTION_OBSERVABILITY_RULES = _i18n.i18n.translate('xpack.alerting.maintenanceWindows.createForm.solutionIds.observabilityRules', {
  defaultMessage: 'Observability rules'
});
const CREATE_FORM_SOLUTION_SECURITY_RULES = exports.CREATE_FORM_SOLUTION_SECURITY_RULES = _i18n.i18n.translate('xpack.alerting.maintenanceWindows.createForm.solutionIds.securityRules', {
  defaultMessage: 'Security rules'
});
const CREATE_FORM_SOLUTION_STACK_RULES = exports.CREATE_FORM_SOLUTION_STACK_RULES = _i18n.i18n.translate('xpack.alerting.maintenanceWindows.createForm.solutionIds.stackRules', {
  defaultMessage: 'Stack rules'
});
const CREATE_FORM_SCOPED_QUERY_TITLE = exports.CREATE_FORM_SCOPED_QUERY_TITLE = _i18n.i18n.translate('xpack.alerting.maintenanceWindows.createForm.scopedQuery.title', {
  defaultMessage: 'Filters'
});
const CREATE_FORM_SCOPED_QUERY_DESCRIPTION = exports.CREATE_FORM_SCOPED_QUERY_DESCRIPTION = _i18n.i18n.translate('xpack.alerting.maintenanceWindows.createForm.scopedQuery.description', {
  defaultMessage: 'Add filters that refine the scope of the maintenance window.'
});
const CREATE_FORM_SCOPED_QUERY_TOGGLE_TITLE = exports.CREATE_FORM_SCOPED_QUERY_TOGGLE_TITLE = _i18n.i18n.translate('xpack.alerting.maintenanceWindows.createForm.scopedQuery.toggleTitle', {
  defaultMessage: 'Filter alerts'
});
const CREATE_FORM_SCOPED_QUERY_INVALID_ERROR_MESSAGE = exports.CREATE_FORM_SCOPED_QUERY_INVALID_ERROR_MESSAGE = _i18n.i18n.translate('xpack.alerting.maintenanceWindows.createForm.scopedQuery.invalidErrorMessage', {
  defaultMessage: 'Invalid scoped query.'
});
const CREATE_FORM_SCOPED_QUERY_EMPTY_ERROR_MESSAGE = exports.CREATE_FORM_SCOPED_QUERY_EMPTY_ERROR_MESSAGE = _i18n.i18n.translate('xpack.alerting.maintenanceWindows.createForm.scopedQuery.emptyErrorMessage', {
  defaultMessage: 'Scoped query is required.'
});
const CREATE_FORM_RECURRING_SUMMARY_PREFIX = summary => _i18n.i18n.translate('xpack.alerting.maintenanceWindows.createForm.recurringSummaryPrefix', {
  defaultMessage: 'Repeats {summary}',
  values: {
    summary
  }
});
exports.CREATE_FORM_RECURRING_SUMMARY_PREFIX = CREATE_FORM_RECURRING_SUMMARY_PREFIX;
const CANCEL = exports.CANCEL = _i18n.i18n.translate('xpack.alerting.maintenanceWindows.createForm.cancel', {
  defaultMessage: 'Cancel'
});
const TABLE_ALERTS = exports.TABLE_ALERTS = _i18n.i18n.translate('xpack.alerting.maintenanceWindows.table.alerts', {
  defaultMessage: 'Alerts'
});

// Add this tooltip to the Alerts column heading on the MW table
const TABLE_ALERTS_TOOLTIP = exports.TABLE_ALERTS_TOOLTIP = _i18n.i18n.translate('xpack.alerting.maintenanceWindows.table.alertsTooltip', {
  defaultMessage: 'The total number of alerts created in the maintenance window.'
});
const TABLE_STATUS = exports.TABLE_STATUS = _i18n.i18n.translate('xpack.alerting.maintenanceWindows.table.status', {
  defaultMessage: 'Status'
});
const TABLE_STATUS_RUNNING = exports.TABLE_STATUS_RUNNING = _i18n.i18n.translate('xpack.alerting.maintenanceWindows.table.statusRunning', {
  defaultMessage: 'Running'
});
const TABLE_STATUS_UPCOMING = exports.TABLE_STATUS_UPCOMING = _i18n.i18n.translate('xpack.alerting.maintenanceWindows.table.statusUpcoming', {
  defaultMessage: 'Upcoming'
});
const TABLE_STATUS_FINISHED = exports.TABLE_STATUS_FINISHED = _i18n.i18n.translate('xpack.alerting.maintenanceWindows.table.statusFinished', {
  defaultMessage: 'Finished'
});
const TABLE_STATUS_ARCHIVED = exports.TABLE_STATUS_ARCHIVED = _i18n.i18n.translate('xpack.alerting.maintenanceWindows.table.statusArchived', {
  defaultMessage: 'Archived'
});
const TABLE_STATUS_DISABLED = exports.TABLE_STATUS_DISABLED = _i18n.i18n.translate('xpack.alerting.maintenanceWindows.table.statusDisabled', {
  defaultMessage: 'Disabled'
});
const TABLE_START_TIME = exports.TABLE_START_TIME = _i18n.i18n.translate('xpack.alerting.maintenanceWindows.table.startTime', {
  defaultMessage: 'Start time'
});
const TABLE_END_TIME = exports.TABLE_END_TIME = _i18n.i18n.translate('xpack.alerting.maintenanceWindows.table.endTime', {
  defaultMessage: 'End time'
});
const TABLE_ACTION_EDIT = exports.TABLE_ACTION_EDIT = _i18n.i18n.translate('xpack.alerting.maintenanceWindows.table.edit', {
  defaultMessage: 'Edit'
});
const EDIT_MAINTENANCE_WINDOW = exports.EDIT_MAINTENANCE_WINDOW = _i18n.i18n.translate('xpack.alerting.maintenanceWindows.edit.maintenanceWindow', {
  defaultMessage: 'Edit maintenance window'
});
const SAVE_MAINTENANCE_WINDOW = exports.SAVE_MAINTENANCE_WINDOW = _i18n.i18n.translate('xpack.alerting.maintenanceWindows.save.maintenanceWindow', {
  defaultMessage: 'Save maintenance window'
});
const TABLE_ACTION_CANCEL = exports.TABLE_ACTION_CANCEL = _i18n.i18n.translate('xpack.alerting.maintenanceWindows.table.cancel', {
  defaultMessage: 'Cancel'
});
const CANCEL_MODAL_TITLE = exports.CANCEL_MODAL_TITLE = _i18n.i18n.translate('xpack.alerting.maintenanceWindows.cancelModal.title', {
  defaultMessage: 'Cancel maintenance window'
});
const CANCEL_MODAL_SUBTITLE = exports.CANCEL_MODAL_SUBTITLE = _i18n.i18n.translate('xpack.alerting.maintenanceWindows.cancelModal.subtitle', {
  defaultMessage: 'Rule notifications resume immediately. Running maintenance window events are canceled; upcoming events are unaffected.'
});
const CANCEL_MODAL_BUTTON = exports.CANCEL_MODAL_BUTTON = _i18n.i18n.translate('xpack.alerting.maintenanceWindows.cancelModal.button', {
  defaultMessage: 'Keep running'
});
const TABLE_ACTION_CANCEL_AND_ARCHIVE = exports.TABLE_ACTION_CANCEL_AND_ARCHIVE = _i18n.i18n.translate('xpack.alerting.maintenanceWindows.table.cancelAndArchive', {
  defaultMessage: 'Cancel and archive'
});
const CANCEL_AND_ARCHIVE_MODAL_TITLE = exports.CANCEL_AND_ARCHIVE_MODAL_TITLE = _i18n.i18n.translate('xpack.alerting.maintenanceWindows.cancelAndArchiveModal.title', {
  defaultMessage: 'Cancel and archive maintenance window'
});
const CANCEL_AND_ARCHIVE_MODAL_SUBTITLE = exports.CANCEL_AND_ARCHIVE_MODAL_SUBTITLE = _i18n.i18n.translate('xpack.alerting.maintenanceWindows.cancelAndArchiveModal.subtitle', {
  defaultMessage: 'Rule notifications resume immediately. All running and upcoming maintenance window events are canceled and the window is queued for deletion.'
});
const DELETE_MODAL_TITLE = exports.DELETE_MODAL_TITLE = _i18n.i18n.translate('xpack.alerting.maintenanceWindows.deleteModal.title', {
  defaultMessage: 'Delete maintenance window'
});
const DELETE_MODAL_SUBTITLE = exports.DELETE_MODAL_SUBTITLE = _i18n.i18n.translate('xpack.alerting.maintenanceWindows.deleteModal.subtitle', {
  defaultMessage: "You won't be able to recover a deleted maintenance window."
});
const ARCHIVE = exports.ARCHIVE = _i18n.i18n.translate('xpack.alerting.maintenanceWindows.archive', {
  defaultMessage: 'Archive'
});
const COPY_ID = exports.COPY_ID = _i18n.i18n.translate('xpack.alerting.maintenanceWindows.copyId', {
  defaultMessage: 'Copy ID'
});
const COPY_ID_ACTION_SUCCESS = exports.COPY_ID_ACTION_SUCCESS = _i18n.i18n.translate('xpack.alerting.maintenanceWindows.copyId.success', {
  defaultMessage: 'Copied maintenance window ID to clipboard'
});
const ARCHIVE_TITLE = exports.ARCHIVE_TITLE = _i18n.i18n.translate('xpack.alerting.maintenanceWindows.archive.title', {
  defaultMessage: 'Archive maintenance window'
});
const ARCHIVE_SUBTITLE = exports.ARCHIVE_SUBTITLE = _i18n.i18n.translate('xpack.alerting.maintenanceWindows.archive.subtitle', {
  defaultMessage: 'Upcoming maintenance window events are canceled and the window is queued for deletion.'
});
const SOLUTION_CONFIG_REMOVAL_WARNING_TITLE = exports.SOLUTION_CONFIG_REMOVAL_WARNING_TITLE = _i18n.i18n.translate('xpack.alerting.maintenanceWindows.solutionConfigRemovalWarning.title', {
  defaultMessage: 'Support for multiple solution categories is removed.'
});
const SOLUTION_CONFIG_REMOVAL_WARNING_SUBTITLE = exports.SOLUTION_CONFIG_REMOVAL_WARNING_SUBTITLE = _i18n.i18n.translate('xpack.alerting.maintenanceWindows.solutionConfigRemovalWarning.subtitle', {
  defaultMessage: 'When you save the changes, the maintenance window will affect all rules that meet the filtering criteria.'
});
const TABLE_ACTION_UNARCHIVE = exports.TABLE_ACTION_UNARCHIVE = _i18n.i18n.translate('xpack.alerting.maintenanceWindows.table.unarchive', {
  defaultMessage: 'Unarchive'
});
const TABLE_ACTION_DELETE = exports.TABLE_ACTION_DELETE = _i18n.i18n.translate('xpack.alerting.maintenanceWindows.table.delete', {
  defaultMessage: 'Delete'
});
const UNARCHIVE_MODAL_TITLE = exports.UNARCHIVE_MODAL_TITLE = _i18n.i18n.translate('xpack.alerting.maintenanceWindows.unarchiveModal.title', {
  defaultMessage: 'Unarchive maintenance window'
});
const UNARCHIVE_MODAL_SUBTITLE = exports.UNARCHIVE_MODAL_SUBTITLE = _i18n.i18n.translate('xpack.alerting.maintenanceWindows.unarchiveModal.subtitle', {
  defaultMessage: 'Upcoming maintenance window events are scheduled.'
});
const ARCHIVE_CALLOUT_SUBTITLE = exports.ARCHIVE_CALLOUT_SUBTITLE = _i18n.i18n.translate('xpack.alerting.maintenanceWindows.archiveCallout.subtitle', {
  defaultMessage: 'Upcoming maintenance window events will be canceled, and the window will be queued for deletion. Any other changes made here will not be saved. Are you sure you want to discard changes and archive this maintenance window?'
});
const UPCOMING = exports.UPCOMING = _i18n.i18n.translate('xpack.alerting.maintenanceWindows.upcoming', {
  defaultMessage: 'Upcoming'
});
const UPGRADE_TO_PLATINUM = exports.UPGRADE_TO_PLATINUM = _i18n.i18n.translate('xpack.alerting.maintenanceWindows.licenseCallout.updgradeToPlatinumTitle', {
  defaultMessage: 'Maintenance windows are a subscription feature'
});
const UPGRADE_TO_PLATINUM_SUBTITLE = exports.UPGRADE_TO_PLATINUM_SUBTITLE = _i18n.i18n.translate('xpack.alerting.maintenanceWindows.licenseCallout.upgradeToPlatinumSubtitle', {
  defaultMessage: 'Select an option to unlock it.'
});
const UPGRADE_SUBSCRIPTION = exports.UPGRADE_SUBSCRIPTION = _i18n.i18n.translate('xpack.alerting.maintenanceWindows.licenseCallout.upgradeSubscription', {
  defaultMessage: 'Upgrade subscription'
});
const START_TRIAL = exports.START_TRIAL = _i18n.i18n.translate('xpack.alerting.maintenanceWindows.licenseCallout.startTrial', {
  defaultMessage: 'Start trial'
});
const REFRESH = exports.REFRESH = _i18n.i18n.translate('xpack.alerting.maintenanceWindows.refreshButton', {
  defaultMessage: 'Refresh'
});
const SEARCH_PLACEHOLDER = exports.SEARCH_PLACEHOLDER = _i18n.i18n.translate('xpack.alerting.maintenanceWindows.searchPlaceholder', {
  defaultMessage: 'Search'
});