"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _lodash = require("lodash");
var _public = require("@kbn/triggers-actions-ui-plugin/public");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765022786381327106/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/stack_connectors/public/connector_types/xmatters/xmatters_params.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const severityOptions = [{
  value: 'critical',
  text: _i18n.i18n.translate('xpack.stackConnectors.components.xmatters.severitySelectCriticalOptionLabel', {
    defaultMessage: 'Critical'
  })
}, {
  value: 'high',
  text: _i18n.i18n.translate('xpack.stackConnectors.components.xmatters.severitySelectHighOptionLabel', {
    defaultMessage: 'High'
  })
}, {
  value: 'medium',
  text: _i18n.i18n.translate('xpack.stackConnectors.components.xmatters.severitySelectMediumOptionLabel', {
    defaultMessage: 'Medium'
  })
}, {
  value: 'low',
  text: _i18n.i18n.translate('xpack.stackConnectors.components.xmatters.severitySelectLowOptionLabel', {
    defaultMessage: 'Low'
  })
}, {
  value: 'minimal',
  text: _i18n.i18n.translate('xpack.stackConnectors.components.xmatters.severitySelectMinimalOptionLabel', {
    defaultMessage: 'Minimal'
  })
}];
const XmattersParamsFields = ({
  actionParams,
  editAction,
  index,
  messageVariables,
  errors
}) => {
  (0, _react.useEffect)(() => {
    if (!actionParams) {
      editAction('actionParams', {
        signalId: '{{rule.id}}:{{alert.id}}',
        alertActionGroupName: '{{alert.actionGroupName}}',
        ruleName: '{{rule.name}}',
        date: '{{date}}',
        spaceId: '{{rule.spaceId}}'
      }, index);
    } else {
      if (!actionParams.signalId) {
        editAction('signalId', 'test-alert', index);
      }
      if (!actionParams.alertActionGroupName) {
        editAction('alertActionGroupName', 'test-rule:test-alert', index);
      }
      if (!actionParams.ruleName) {
        editAction('ruleName', 'Test Rule', index);
      }
      if (!actionParams.date) {
        editAction('date', new Date().toISOString(), index);
      }
      if (!actionParams.spaceId) {
        editAction('spaceId', 'test-space', index);
      }
    }

    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [actionParams]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 103,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 104,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    id: "xmattersSeverity",
    fullWidth: true,
    label: _i18n.i18n.translate('xpack.stackConnectors.components.xmatters.severity', {
      defaultMessage: 'Severity'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 105,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    fullWidth: true,
    "data-test-subj": "severitySelect",
    options: severityOptions,
    hasNoInitialSelection: (0, _lodash.isUndefined)(actionParams.severity),
    value: actionParams.severity,
    onChange: e => {
      editAction('severity', e.target.value, index);
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 112,
      columnNumber: 13
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 125,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 126,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    id: "xmattersTags",
    fullWidth: true,
    label: _i18n.i18n.translate('xpack.stackConnectors.components.xmatters.tags', {
      defaultMessage: 'Tags'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 127,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_public.TextFieldWithMessageVariables, {
    index: index,
    editAction: editAction,
    messageVariables: messageVariables,
    paramsProperty: 'tags',
    inputTargetValue: actionParams.tags,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 134,
      columnNumber: 13
    }
  })))));
};

// eslint-disable-next-line import/no-default-export
exports.default = XmattersParamsFields;
module.exports = exports.default;