"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _helpers = require("@kbn/es-ui-shared-plugin/static/forms/helpers");
var _hook_form_lib = require("@kbn/es-ui-shared-plugin/static/forms/hook_form_lib");
var _components = require("@kbn/es-ui-shared-plugin/static/forms/components");
var _types = require("../types");
var i18n = _interopRequireWildcard(require("./translations"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765022786381327106/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/stack_connectors/public/connector_types/xmatters/xmatters_connectors.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const {
  emptyField,
  urlField
} = _helpers.fieldValidators;
const isBasicAuth = auth => {
  if (auth == null) {
    return true;
  }
  return auth.auth === _types.XmattersAuthenticationType.Basic ? true : false;
};
const authenticationButtons = [{
  id: _types.XmattersAuthenticationType.Basic,
  label: i18n.BASIC_AUTH_BUTTON_LABEL
}, {
  id: _types.XmattersAuthenticationType.URL,
  label: i18n.URL_AUTH_BUTTON_LABEL
}];
const XmattersUrlField = ({
  path,
  readOnly
}) => {
  return /*#__PURE__*/_react.default.createElement(_hook_form_lib.UseField, {
    path: path,
    component: _components.TextField,
    config: {
      label: i18n.URL_LABEL,
      helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.stackConnectors.components.xmatters.initiationUrlHelpText",
        defaultMessage: "Include the full xMatters url.",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 57,
          columnNumber: 11
        }
      }),
      validations: [{
        validator: urlField(i18n.URL_INVALID)
      }]
    },
    componentProps: {
      euiFieldProps: {
        'data-test-subj': path,
        readOnly
      }
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 51,
      columnNumber: 5
    }
  });
};
const XmattersActionConnectorFields = ({
  readOnly
}) => {
  var _getFieldDefaultValue;
  const {
    setFieldValue,
    getFieldDefaultValue
  } = (0, _hook_form_lib.useFormContext)();
  const [{
    config,
    __internal__
  }] = (0, _hook_form_lib.useFormData)({
    watch: ['config.usesBasic', '__internal__.auth']
  });
  const usesBasicDefaultValue = (_getFieldDefaultValue = getFieldDefaultValue('config.usesBasic')) !== null && _getFieldDefaultValue !== void 0 ? _getFieldDefaultValue : true;
  const selectedAuthDefaultValue = usesBasicDefaultValue ? _types.XmattersAuthenticationType.Basic : _types.XmattersAuthenticationType.URL;
  const selectedAuth = config != null && !config.usesBasic ? _types.XmattersAuthenticationType.URL : _types.XmattersAuthenticationType.Basic;
  (0, _react.useEffect)(() => {
    setFieldValue('config.usesBasic', isBasicAuth(__internal__));
  }, [__internal__, setFieldValue]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 101,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("h4", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 102,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.stackConnectors.components.xmatters.authenticationLabel",
    defaultMessage: "Authentication",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 103,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 109,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_hook_form_lib.UseField, {
    path: "__internal__.auth",
    component: _components.ButtonGroupField,
    config: {
      label: i18n.BASIC_AUTH_LABEL,
      defaultValue: selectedAuthDefaultValue,
      validations: [{
        validator: emptyField(i18n.BASIC_AUTH_REQUIRED)
      }]
    },
    componentProps: {
      euiFieldProps: {
        legend: i18n.BASIC_AUTH_BUTTON_GROUP_LEGEND,
        options: authenticationButtons,
        buttonSize: 'm',
        color: 'primary'
      }
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 110,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_hook_form_lib.UseField, {
    path: "config.usesBasic",
    component: _components.HiddenField,
    config: {
      defaultValue: true
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 131,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 132,
      columnNumber: 7
    }
  }), selectedAuth === _types.XmattersAuthenticationType.URL ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 134,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 135,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(XmattersUrlField, {
    path: "secrets.secretsUrl",
    readOnly: readOnly,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 136,
      columnNumber: 13
    }
  }))) : null, selectedAuth === _types.XmattersAuthenticationType.Basic ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 142,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 143,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(XmattersUrlField, {
    path: "config.configUrl",
    readOnly: readOnly,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 144,
      columnNumber: 15
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 147,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 148,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("h4", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 149,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    "data-test-subj": "userCredsLabel",
    id: "xpack.stackConnectors.components.xmatters.userCredsLabel",
    defaultMessage: "User credentials",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 150,
      columnNumber: 15
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 157,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 158,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 159,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 160,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_hook_form_lib.UseField, {
    path: "secrets.user",
    component: _components.TextField,
    config: {
      label: i18n.USERNAME_LABEL,
      validations: [{
        validator: emptyField(i18n.USERNAME_INVALID)
      }]
    },
    componentProps: {
      euiFieldProps: {
        disabled: readOnly,
        'data-test-subj': 'xmattersUserInput',
        readOnly
      }
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 161,
      columnNumber: 15
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 182,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 183,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_hook_form_lib.UseField, {
    path: "secrets.password",
    config: {
      label: i18n.PASSWORD_LABEL,
      validations: [{
        validator: emptyField(i18n.PASSWORD_REQUIRED)
      }]
    },
    component: _components.PasswordField,
    componentProps: {
      euiFieldProps: {
        'data-test-subj': 'xmattersPasswordInput',
        readOnly
      }
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 184,
      columnNumber: 15
    }
  })))) : null);
};

// eslint-disable-next-line import/no-default-export
exports.default = XmattersActionConnectorFields;
module.exports = exports.default;