"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _helpers = require("@kbn/es-ui-shared-plugin/static/forms/helpers");
var _hook_form_lib = require("@kbn/es-ui-shared-plugin/static/forms/hook_form_lib");
var _components = require("@kbn/es-ui-shared-plugin/static/forms/components");
var _public = require("@kbn/triggers-actions-ui-plugin/public");
var i18n = _interopRequireWildcard(require("./translations"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765022786381327106/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/stack_connectors/public/connector_types/email/exchange_form.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const {
  emptyField
} = _helpers.fieldValidators;
const ExchangeFormFields = ({
  readOnly
}) => {
  const {
    docLinks
  } = (0, _public.useKibana)().services;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 28,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 29,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_hook_form_lib.UseField, {
    path: "config.tenantId",
    component: _components.TextField,
    config: {
      label: i18n.TENANT_ID_LABEL,
      helpText: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        href: docLinks.links.alerting.emailExchangeClientIdConfig,
        target: "_blank",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 36,
          columnNumber: 17
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.stackConnectors.components.email.exchangeForm.tenantIdHelpLabel",
        defaultMessage: "Configure Tenant ID",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 37,
          columnNumber: 19
        }
      })),
      validations: [{
        validator: emptyField(i18n.TENANT_ID_REQUIRED)
      }]
    },
    componentProps: {
      euiFieldProps: {
        'data-test-subj': 'emailTenantId'
      },
      readOnly,
      placeholder: '00000000-0000-0000-0000-000000000000'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 30,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 56,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_hook_form_lib.UseField, {
    path: "config.clientId",
    component: _components.TextField,
    config: {
      label: i18n.CLIENT_ID_LABEL,
      helpText: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        href: docLinks.links.alerting.emailExchangeClientIdConfig,
        target: "_blank",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 63,
          columnNumber: 17
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.stackConnectors.components.email.exchangeForm.clientIdHelpLabel",
        defaultMessage: "Configure Client ID",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 64,
          columnNumber: 19
        }
      })),
      validations: [{
        validator: emptyField(i18n.CLIENT_ID_REQUIRED)
      }]
    },
    componentProps: {
      euiFieldProps: {
        'data-test-subj': 'emailClientId'
      },
      readOnly,
      placeholder: '00000000-0000-0000-0000-000000000000'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 57,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 84,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 85,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_hook_form_lib.UseField, {
    path: "secrets.clientSecret",
    config: {
      label: i18n.CLIENT_SECRET_LABEL,
      validations: [{
        validator: emptyField(i18n.CLIENT_SECRET_REQUIRED)
      }],
      helpText: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        href: docLinks.links.alerting.emailExchangeClientSecretConfig,
        target: "_blank",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 96,
          columnNumber: 17
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.stackConnectors.components.email.exchangeForm.clientSecretHelpLabel",
        defaultMessage: "Configure Client Secret",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 100,
          columnNumber: 19
        }
      }))
    },
    component: _components.PasswordField,
    componentProps: {
      euiFieldProps: {
        readOnly,
        'data-test-subj': 'emailClientSecret'
      }
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 86,
      columnNumber: 11
    }
  }))));
};

// eslint-disable-next-line import/no-default-export
exports.default = ExchangeFormFields;
module.exports = exports.default;