"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SeverityFilter = exports.CaseSeverity = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _translations = _interopRequireWildcard(require("./translations"));
var i18n = _translations;
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765022786381327106/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/stack_connectors/public/connector_types/cases_webhook/severity_filter.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
let CaseSeverity = exports.CaseSeverity = /*#__PURE__*/function (CaseSeverity) {
  CaseSeverity["LOW"] = "low";
  CaseSeverity["MEDIUM"] = "medium";
  CaseSeverity["HIGH"] = "high";
  CaseSeverity["CRITICAL"] = "critical";
  return CaseSeverity;
}({});
const SeverityFilter = ({
  selectedSeverity,
  onSeverityChange
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const isAmsterdam = euiTheme.flags.hasVisColorAdjustment;
  const severities = {
    [CaseSeverity.LOW]: {
      color: isAmsterdam ? euiTheme.colors.vis.euiColorVis0 : euiTheme.colors.severity.neutral,
      label: i18n.SEVERITY_LOW_LABEL
    },
    [CaseSeverity.MEDIUM]: {
      color: isAmsterdam ? euiTheme.colors.vis.euiColorVis5 : euiTheme.colors.severity.warning,
      label: i18n.SEVERITY_MEDIUM_LABEL
    },
    [CaseSeverity.HIGH]: {
      color: isAmsterdam ? euiTheme.colors.vis.euiColorVis7 : euiTheme.colors.severity.risk,
      label: i18n.SEVERITY_HIGH_LABEL
    },
    [CaseSeverity.CRITICAL]: {
      color: isAmsterdam ? euiTheme.colors.vis.euiColorVis9 : euiTheme.colors.severity.danger,
      label: i18n.SEVERITY_CRITICAL_LABEL
    }
  };
  const caseSeverities = Object.keys(severities);
  const options = caseSeverities.map(severity => {
    const severityData = severities[severity];
    return {
      value: severity,
      inputDisplay: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        gutterSize: "xs",
        alignItems: 'center',
        responsive: false,
        "data-test-subj": `case-severity-selection-${severity}`,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 55,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 61,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiHealth, {
        color: severityData.color,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 62,
          columnNumber: 13
        }
      }, severityData.label)))
    };
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiSuperSelect, {
    fullWidth: true,
    options: options,
    valueOfSelected: selectedSeverity,
    onChange: onSeverityChange,
    "data-test-subj": "case-severity-selection",
    "aria-label": _translations.CASE_SEVERITY_ARIA_LABEL,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 70,
      columnNumber: 5
    }
  });
};
exports.SeverityFilter = SeverityFilter;
SeverityFilter.displayName = 'SeverityFilter';