"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ThresholdVisualization = void 0;
var _react = _interopRequireWildcard(require("react"));
var _rxjs = require("rxjs");
var _charts = require("@elastic/charts");
var _momentTimezone = _interopRequireDefault(require("moment-timezone"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _public = require("@kbn/kibana-react-plugin/public");
var _parse_duration = require("@kbn/alerting-plugin/common/parse_duration");
var _i18n = require("@kbn/i18n");
var _index_threshold_api = require("./index_threshold_api");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765022786381327106/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/stack_alerts/public/rule_types/threshold/visualization.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const chartThemeOverrides = () => {
  return {
    lineSeriesStyle: {
      line: {
        strokeWidth: 3
      },
      point: {
        visible: 'never'
      }
    }
  };
};
const getTimezone = uiSettings => {
  const config = uiSettings;
  const DATE_FORMAT_CONFIG_KEY = 'dateFormat:tz';
  const isCustomTimezone = !config.isDefault(DATE_FORMAT_CONFIG_KEY);
  if (isCustomTimezone) {
    return config.get(DATE_FORMAT_CONFIG_KEY);
  }
  const detectedTimezone = _momentTimezone.default.tz.guess();
  if (detectedTimezone) {
    return detectedTimezone;
  }
  // default to UTC if we can't figure out the timezone
  const tzOffset = (0, _momentTimezone.default)().format('Z');
  return tzOffset;
};
const getDomain = (alertInterval, startAt) => {
  const VISUALIZE_INTERVALS = 30;
  let intervalMillis;
  try {
    intervalMillis = (0, _parse_duration.parseDuration)(alertInterval);
  } catch (err) {
    intervalMillis = 1000 * 60; // default to one minute if not parseable
  }
  return {
    min: startAt.getTime() - intervalMillis * VISUALIZE_INTERVALS,
    max: startAt.getTime()
  };
};
const DEFAULT_REFRESH_RATE = 5000;
var LoadingStateType = /*#__PURE__*/function (LoadingStateType) {
  LoadingStateType[LoadingStateType["FirstLoad"] = 0] = "FirstLoad";
  LoadingStateType[LoadingStateType["Refresh"] = 1] = "Refresh";
  LoadingStateType[LoadingStateType["Idle"] = 2] = "Idle";
  return LoadingStateType;
}(LoadingStateType || {});
// [epochMillis, value]
const ThresholdVisualization = ({
  ruleParams,
  alertInterval,
  aggregationTypes,
  comparators,
  refreshRateInMilliseconds = DEFAULT_REFRESH_RATE,
  charts,
  dataFieldsFormats
}) => {
  const {
    index,
    timeField,
    aggType,
    aggField,
    termSize,
    termField,
    thresholdComparator,
    timeWindowSize,
    timeWindowUnit,
    groupBy,
    threshold
  } = ruleParams;
  const {
    http,
    uiSettings
  } = (0, _public.useKibana)().services;
  const [loadingState, setLoadingState] = (0, _react.useState)(null);
  const [hasError, setHasError] = (0, _react.useState)(false);
  const [errorMessage, setErrorMessage] = (0, _react.useState)(undefined);
  const [visualizationData, setVisualizationData] = (0, _react.useState)();
  const [startVisualizationAt, setStartVisualizationAt] = (0, _react.useState)(new Date());
  (0, _react.useEffect)(() => {
    const source = (0, _rxjs.interval)(refreshRateInMilliseconds);
    const subscription = source.subscribe(val => {
      setStartVisualizationAt(new Date());
    });
    return () => {
      subscription.unsubscribe();
    };
  }, [refreshRateInMilliseconds]);
  (0, _react.useEffect)(() => {
    (async () => {
      try {
        setLoadingState(loadingState ? LoadingStateType.Refresh : LoadingStateType.FirstLoad);
        setVisualizationData(await getVisualizationData(alertWithoutActions, visualizeOptions, http));
        setHasError(false);
        setErrorMessage(undefined);
      } catch (e) {
        var _e$body;
        setHasError(true);
        setErrorMessage((e === null || e === void 0 ? void 0 : (_e$body = e.body) === null || _e$body === void 0 ? void 0 : _e$body.message) || (e === null || e === void 0 ? void 0 : e.message));
      } finally {
        setLoadingState(LoadingStateType.Idle);
      }
    })();
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [index, timeField, aggType, aggField, termSize, termField, thresholdComparator, timeWindowSize, timeWindowUnit, groupBy, threshold, startVisualizationAt]);
  if (!charts || !uiSettings || !dataFieldsFormats) {
    return null;
  }
  const chartsBaseTheme = charts.theme.useChartsBaseTheme();
  const domain = getDomain(alertInterval, startVisualizationAt);
  const visualizeOptions = {
    rangeFrom: new Date(domain.min).toISOString(),
    rangeTo: new Date(domain.max).toISOString(),
    interval: alertInterval
  };

  // Fetching visualization data is independent of alert actions
  const alertWithoutActions = {
    ...ruleParams,
    actions: [],
    type: 'threshold'
  };
  if (loadingState === LoadingStateType.FirstLoad) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
      "data-test-subj": "firstLoad",
      title: /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingChart, {
        size: "xl",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 201,
          columnNumber: 16
        }
      }),
      body: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        color: "subdued",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 203,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.stackAlerts.threshold.ui.visualization.loadingAlertVisualizationDescription",
        defaultMessage: "Loading alert visualization\u2026",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 204,
          columnNumber: 13
        }
      })),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 199,
        columnNumber: 7
      }
    });
  }
  if (hasError) {
    return /*#__PURE__*/_react.default.createElement(_react.Fragment, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 216,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "l",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 217,
        columnNumber: 9
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      "data-test-subj": "errorCallout",
      title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.stackAlerts.threshold.ui.visualization.errorLoadingAlertVisualizationTitle",
        defaultMessage: "Cannot load alert visualization",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 221,
          columnNumber: 13
        }
      }),
      color: "danger",
      iconType: "warning",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 218,
        columnNumber: 9
      }
    }, errorMessage));
  }
  const getThreshold = () => {
    return thresholdComparator ? threshold.slice(0, comparators[thresholdComparator].requiredValues) : [];
  };
  if (visualizationData) {
    const alertVisualizationDataKeys = Object.keys(visualizationData);
    const timezone = getTimezone(uiSettings);
    const actualThreshold = getThreshold();
    let maxY = actualThreshold[actualThreshold.length - 1];
    Object.values(visualizationData).forEach(data => {
      data.forEach(([, y]) => {
        if (y > maxY) {
          maxY = y;
        }
      });
    });
    const dateFormatter = (0, _charts.niceTimeFormatter)([domain.min, domain.max]);
    const aggLabel = aggregationTypes[aggType].text;
    return /*#__PURE__*/_react.default.createElement("div", {
      "data-test-subj": "alertVisualizationChart",
      style: {
        position: 'relative'
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 257,
        columnNumber: 7
      }
    }, loadingState === LoadingStateType.Refresh ? /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
      size: "l",
      style: {
        position: 'absolute',
        top: '8%',
        right: '5%'
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 259,
        columnNumber: 11
      }
    }) : /*#__PURE__*/_react.default.createElement(_react.Fragment, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 261,
        columnNumber: 11
      }
    }), alertVisualizationDataKeys.length ? /*#__PURE__*/_react.default.createElement(_charts.Chart, {
      size: ['100%', 200],
      renderer: "canvas",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 264,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_charts.Settings, {
      theme: [chartThemeOverrides()],
      baseTheme: chartsBaseTheme,
      xDomain: domain,
      showLegend: !!termField,
      legendPosition: _charts.Position.Bottom,
      locale: _i18n.i18n.getLocale(),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 265,
        columnNumber: 13
      }
    }), /*#__PURE__*/_react.default.createElement(_charts.Axis, {
      id: "bottom",
      position: _charts.Position.Bottom,
      showOverlappingTicks: true,
      tickFormat: dateFormatter,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 273,
        columnNumber: 13
      }
    }), /*#__PURE__*/_react.default.createElement(_charts.Axis, {
      domain: {
        max: maxY,
        min: NaN
      },
      id: "left",
      title: aggLabel,
      position: _charts.Position.Left,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 279,
        columnNumber: 13
      }
    }), alertVisualizationDataKeys.map(key => {
      return /*#__PURE__*/_react.default.createElement(_charts.LineSeries, {
        key: key,
        id: key
        // Defaults to multi layer time axis as of Elastic Charts v70
        ,
        xScaleType: _charts.ScaleType.Time,
        yScaleType: _charts.ScaleType.Linear,
        data: visualizationData[key],
        xAccessor: 0,
        yAccessors: [1],
        timeZone: timezone,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 287,
          columnNumber: 17
        }
      });
    }), actualThreshold.map((_value, thresholdIndex) => {
      const specId = thresholdIndex === 0 ? 'threshold' : `threshold${thresholdIndex}`;
      return /*#__PURE__*/_react.default.createElement(_charts.LineAnnotation, {
        key: specId,
        id: specId,
        domainType: _charts.AnnotationDomainType.YDomain,
        dataValues: [{
          dataValue: threshold[thresholdIndex],
          details: specId
        }],
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 303,
          columnNumber: 17
        }
      });
    })) : /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      "data-test-subj": "noDataCallout",
      size: "s",
      title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.stackAlerts.threshold.ui.visualization.thresholdPreviewChart.noDataTitle",
        defaultMessage: "No data matches this query",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 317,
          columnNumber: 15
        }
      }),
      color: "warning",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 313,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.stackAlerts.threshold.ui.visualization.thresholdPreviewChart.dataDoesNotExistTextMessage",
      defaultMessage: "Check that your time range and filters are correct.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 324,
        columnNumber: 13
      }
    })));
  }
  return null;
};

// convert the data from the visualization API into something easier to digest with charts
exports.ThresholdVisualization = ThresholdVisualization;
async function getVisualizationData(model, visualizeOptions, http) {
  const vizData = await (0, _index_threshold_api.getThresholdRuleVisualizationData)({
    model,
    visualizeOptions,
    http
  });
  const result = {};
  for (const groupMetrics of vizData.results) {
    result[groupMetrics.group] = groupMetrics.metrics.map(metricResult => [Date.parse(metricResult[0]), metricResult[1]]);
  }
  return result;
}