"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EntityForm = exports.ENTITY_GEO_FIELD_TYPES = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _data_view_select = require("./data_view_select");
var _single_field_select = require("./single_field_select");
var _query_input = require("./query_input");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765022786381327106/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/stack_alerts/public/rule_types/geo_containment/rule_form/entity_form.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ENTITY_GEO_FIELD_TYPES = exports.ENTITY_GEO_FIELD_TYPES = ['geo_point', 'geo_shape'];
function getDateFields(fields) {
  return fields.filter(field => field.type === 'date');
}
function getEntityFields(fields) {
  return fields.filter(field => field.aggregatable && ['string', 'number', 'ip'].includes(field.type) && !field.name.startsWith('_'));
}
function getGeoFields(fields) {
  return fields.filter(field => ENTITY_GEO_FIELD_TYPES.includes(field.type));
}
const EntityForm = props => {
  const [isLoading, setIsLoading] = (0, _react.useState)(false);
  const [dataView, setDataView] = (0, _react.useState)();
  const [dataViewNotFound, setDataViewNotFound] = (0, _react.useState)(false);
  const [dateFields, setDateFields] = (0, _react.useState)([]);
  const [entityFields, setEntityFields] = (0, _react.useState)([]);
  const [geoFields, setGeoFields] = (0, _react.useState)([]);
  (0, _react.useEffect)(() => {
    if (!props.ruleParams.indexId || props.ruleParams.indexId === (dataView === null || dataView === void 0 ? void 0 : dataView.id)) {
      return;
    }
    let ignore = false;
    setIsLoading(true);
    setDataViewNotFound(false);
    props.data.indexPatterns.get(props.ruleParams.indexId).then(nextDataView => {
      if (!ignore) {
        setDataView(nextDataView);
        setDateFields(getDateFields(nextDataView.fields));
        setEntityFields(getEntityFields(nextDataView.fields));
        setGeoFields(getGeoFields(nextDataView.fields));
        setIsLoading(false);
      }
    }).catch(() => {
      if (!ignore) {
        setDataViewNotFound(true);
        setIsLoading(false);
      }
    });
    return () => {
      ignore = true;
    };
  }, [props.ruleParams.indexId, dataView === null || dataView === void 0 ? void 0 : dataView.id, props.data.indexPatterns]);
  function getDataViewError() {
    const validationError = props.getValidationError('index');
    if (validationError) {
      return validationError;
    }
    if (dataView && dateFields.length === 0) {
      return _i18n.i18n.translate('xpack.stackAlerts.geoContainment.noDateFieldInIndexPattern.message', {
        defaultMessage: 'Data view does not contain date fields.'
      });
    }
    if (dataView && geoFields.length === 0) {
      return _i18n.i18n.translate('xpack.stackAlerts.geoContainment.noGeoFieldInIndexPattern.message', {
        defaultMessage: 'Data view does not contain geospatial fields. Must have one of type: {geoFieldTypes}.',
        values: {
          geoFieldTypes: ENTITY_GEO_FIELD_TYPES.join(', ')
        }
      });
    }
    if (dataViewNotFound) {
      return _i18n.i18n.translate('xpack.stackAlerts.geoContainment.dataViewNotFound', {
        defaultMessage: `Unable to find data view ''{id}''`,
        values: {
          id: props.ruleParams.indexId
        }
      });
    }
    return null;
  }
  const dataViewError = getDataViewError();
  const dateFieldError = props.getValidationError('dateField');
  const geoFieldError = props.getValidationError('geoField');
  const entityFieldError = props.getValidationError('entity');
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 130,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 131,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("h5", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 132,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.stackAlerts.geoContainment.entitiesFormLabel",
    defaultMessage: "Entities",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 133,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 140,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonText, {
    lines: 3,
    size: "s",
    isLoading: isLoading,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 142,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    error: dataViewError,
    isInvalid: Boolean(dataViewError),
    label: _i18n.i18n.translate('xpack.stackAlerts.geoContainment.dataViewLabel', {
      defaultMessage: 'Data view'
    }),
    "data-test-subj": "entitiesDataView",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 143,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_data_view_select.DataViewSelect, {
    dataViewId: props.ruleParams.indexId,
    data: props.data,
    isInvalid: Boolean(dataViewError),
    onChange: nextDataView => {
      if (!nextDataView.id) {
        return;
      }
      props.setDataViewId(nextDataView.id);
      props.setDataViewTitle(nextDataView.title);
      const nextDateFields = getDateFields(nextDataView.fields);
      if (nextDateFields.length) {
        props.setDateField(nextDateFields[0].name);
      } else if ('dateField' in props.ruleParams) {
        props.setDateField('');
      }

      // do not attempt to auto select entity field
      // there can be many matches so auto selecting the correct field is improbable
      if ('entity' in props.ruleParams) {
        props.setEntityField('');
      }
      const nextGeoFields = getGeoFields(nextDataView.fields);
      if (nextGeoFields.length) {
        props.setGeoField(nextGeoFields[0].name);
      } else if ('geoField' in props.ruleParams) {
        props.setGeoField('');
      }
    },
    unifiedSearch: props.unifiedSearch,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 151,
      columnNumber: 11
    }
  })), props.ruleParams.indexId && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    error: dateFieldError,
    isInvalid: Boolean(dateFieldError),
    label: _i18n.i18n.translate('xpack.stackAlerts.geoContainment.timeFieldLabel', {
      defaultMessage: 'Time'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 188,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_single_field_select.SingleFieldSelect, {
    isInvalid: Boolean(dateFieldError),
    placeholder: _i18n.i18n.translate('xpack.stackAlerts.geoContainment.selectTimeLabel', {
      defaultMessage: 'Select time field'
    }),
    value: props.ruleParams.dateField,
    onChange: fieldName => {
      if (fieldName) {
        props.setDateField(fieldName);
      }
    },
    fields: dateFields,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 195,
      columnNumber: 15
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    error: geoFieldError,
    isInvalid: Boolean(geoFieldError),
    label: _i18n.i18n.translate('xpack.stackAlerts.geoContainment.geofieldLabel', {
      defaultMessage: 'Location'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 210,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_single_field_select.SingleFieldSelect, {
    isInvalid: Boolean(geoFieldError),
    placeholder: _i18n.i18n.translate('xpack.stackAlerts.geoContainment.selectGeoLabel', {
      defaultMessage: 'Select location field'
    }),
    value: props.ruleParams.geoField,
    onChange: fieldName => {
      if (fieldName) {
        props.setGeoField(fieldName);
      }
    },
    fields: geoFields,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 217,
      columnNumber: 15
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    error: entityFieldError,
    isInvalid: Boolean(entityFieldError),
    label: _i18n.i18n.translate('xpack.stackAlerts.geoContainment.entityfieldLabel', {
      defaultMessage: 'Entity'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 232,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_single_field_select.SingleFieldSelect, {
    isInvalid: Boolean(entityFieldError),
    placeholder: _i18n.i18n.translate('xpack.stackAlerts.geoContainment.topHitsSplitFieldSelectPlaceholder', {
      defaultMessage: 'Select entity field'
    }),
    value: props.ruleParams.entity,
    onChange: fieldName => {
      if (fieldName) {
        props.setEntityField(fieldName);
      }
    },
    fields: entityFields,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 239,
      columnNumber: 15
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    helpText: _i18n.i18n.translate('xpack.stackAlerts.geoContainment.entityFilterHelpText', {
      defaultMessage: 'Add a filter to narrow entities.'
    }),
    label: _i18n.i18n.translate('xpack.stackAlerts.geoContainment.filterLabel', {
      defaultMessage: 'Filter'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 257,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_query_input.QueryInput, {
    dataView: dataView,
    onChange: query => {
      props.setQuery(query);
    },
    query: props.ruleParams.indexQuery,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 265,
      columnNumber: 15
    }
  })))));
};
exports.EntityForm = EntityForm;