"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SearchSourceExpression = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _types = require("../types");
var _search_source_expression_form = require("./search_source_expression_form");
var _constants = require("../constants");
var _util = require("../util");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765022786381327106/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/stack_alerts/public/rule_types/es_query/expression/search_source_expression.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const SearchSourceExpression = ({
  ruleParams,
  errors,
  setRuleParams,
  setRuleProperty,
  metadata,
  onChangeMetaData
}) => {
  const {
    thresholdComparator,
    threshold,
    timeWindowSize,
    timeWindowUnit,
    size,
    savedQueryId,
    searchConfiguration,
    aggType,
    aggField,
    groupBy,
    termField,
    termSize,
    excludeHitsFromPreviousRun
  } = ruleParams;
  const {
    data,
    isServerless
  } = (0, _util.useTriggerUiActionServices)();
  const [searchSource, setSearchSource] = (0, _react.useState)();
  const [savedQuery, setSavedQuery] = (0, _react.useState)();
  const [paramsError, setParamsError] = (0, _react.useState)();
  const setParam = (0, _react.useCallback)((paramField, paramValue) => {
    setRuleParams(paramField, paramValue);
  }, [setRuleParams]);
  (0, _react.useEffect)(() => {
    const initSearchSource = async () => {
      let initialSearchConfiguration = searchConfiguration;

      // Init searchConfiguration when creating rule from Stack Management page
      if (!searchConfiguration) {
        const newSearchSource = data.search.searchSource.createEmpty();
        newSearchSource.setField('query', data.query.queryString.getDefaultQuery());
        const defaultDataView = await data.dataViews.getDefaultDataView();
        if (defaultDataView) {
          newSearchSource.setField('index', defaultDataView);
        }
        initialSearchConfiguration = newSearchSource.getSerializedFields();
      }
      try {
        var _createdSearchSource$;
        const createdSearchSource = await data.search.searchSource.create(initialSearchConfiguration);
        setRuleProperty('params', {
          searchConfiguration: initialSearchConfiguration,
          timeField: (_createdSearchSource$ = createdSearchSource.getField('index')) === null || _createdSearchSource$ === void 0 ? void 0 : _createdSearchSource$.timeFieldName,
          searchType: _types.SearchType.searchSource,
          timeWindowSize: timeWindowSize !== null && timeWindowSize !== void 0 ? timeWindowSize : _constants.DEFAULT_VALUES.TIME_WINDOW_SIZE,
          timeWindowUnit: timeWindowUnit !== null && timeWindowUnit !== void 0 ? timeWindowUnit : _constants.DEFAULT_VALUES.TIME_WINDOW_UNIT,
          threshold: threshold !== null && threshold !== void 0 ? threshold : _constants.DEFAULT_VALUES.THRESHOLD,
          thresholdComparator: thresholdComparator !== null && thresholdComparator !== void 0 ? thresholdComparator : _constants.DEFAULT_VALUES.THRESHOLD_COMPARATOR,
          size: size !== null && size !== void 0 ? size : isServerless ? _constants.SERVERLESS_DEFAULT_VALUES.SIZE : _constants.DEFAULT_VALUES.SIZE,
          aggType: aggType !== null && aggType !== void 0 ? aggType : _constants.DEFAULT_VALUES.AGGREGATION_TYPE,
          aggField,
          groupBy: groupBy !== null && groupBy !== void 0 ? groupBy : _constants.DEFAULT_VALUES.GROUP_BY,
          termField,
          termSize: termSize !== null && termSize !== void 0 ? termSize : _constants.DEFAULT_VALUES.TERM_SIZE,
          excludeHitsFromPreviousRun: excludeHitsFromPreviousRun !== null && excludeHitsFromPreviousRun !== void 0 ? excludeHitsFromPreviousRun : _constants.DEFAULT_VALUES.EXCLUDE_PREVIOUS_HITS,
          // The sourceFields param is ignored
          sourceFields: []
        });
        setSearchSource(createdSearchSource);
      } catch (error) {
        setParamsError(error);
      }
    };
    initSearchSource();
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [data.search.searchSource, data.dataViews]);
  (0, _react.useEffect)(() => {
    if (savedQueryId) {
      data.query.savedQueries.getSavedQuery(savedQueryId).then(setSavedQuery);
    }
  }, [data.query.savedQueries, savedQueryId]);
  if (paramsError) {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      color: "danger",
      iconType: "warning",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 117,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement("p", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 118,
        columnNumber: 11
      }
    }, paramsError.message)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 120,
        columnNumber: 9
      }
    }));
  }
  if (!searchSource) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
      title: /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
        "data-test-subj": "searchSourceLoadingSpinner",
        size: "xl",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 128,
          columnNumber: 16
        }
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 127,
        columnNumber: 7
      }
    });
  }
  return /*#__PURE__*/_react.default.createElement(_search_source_expression_form.SearchSourceExpressionForm, {
    ruleParams: ruleParams,
    searchSource: searchSource,
    errors: errors,
    initialSavedQuery: savedQuery,
    setParam: setParam,
    metadata: metadata,
    onChangeMetaData: onChangeMetaData,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 134,
      columnNumber: 5
    }
  });
};
exports.SearchSourceExpression = SearchSourceExpression;