"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ServerSentEventErrorCode = exports.ServerSentEventError = void 0;
exports.createSSEInternalError = createSSEInternalError;
exports.createSSERequestError = createSSERequestError;
exports.isSSEError = isSSEError;
exports.isSSEInternalError = isSSEInternalError;
exports.isSSERequestError = isSSERequestError;
var _i18n = require("@kbn/i18n");
var _events = require("./events");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
let ServerSentEventErrorCode = exports.ServerSentEventErrorCode = /*#__PURE__*/function (ServerSentEventErrorCode) {
  ServerSentEventErrorCode["internalError"] = "internalError";
  ServerSentEventErrorCode["requestError"] = "requestError";
  return ServerSentEventErrorCode;
}({});
class ServerSentEventError extends Error {
  constructor(code, message, meta) {
    super(message);
    this.code = code;
    this.meta = meta;
  }
  get status() {
    if (typeof this.meta === 'object' && this.meta.status) {
      return this.meta.status;
    }
    return undefined;
  }
  toJSON() {
    return {
      type: _events.ServerSentEventType.error,
      error: {
        code: this.code,
        message: this.message,
        meta: this.meta
      }
    };
  }
}
exports.ServerSentEventError = ServerSentEventError;
function createSSEInternalError(message = _i18n.i18n.translate('sse.internalError', {
  defaultMessage: 'An internal error occurred'
})) {
  return new ServerSentEventError(ServerSentEventErrorCode.internalError, message, {});
}
function createSSERequestError(message, status) {
  return new ServerSentEventError(ServerSentEventErrorCode.requestError, message, {
    status
  });
}
function isSSEError(error) {
  return error instanceof ServerSentEventError;
}
function isSSEInternalError(error) {
  return isSSEError(error) && error.code === ServerSentEventErrorCode.internalError;
}
function isSSERequestError(error) {
  return isSSEError(error) && error.code === ServerSentEventErrorCode.requestError;
}