"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getComponents = void 0;
var _react = _interopRequireDefault(require("react"));
var _lazy_wrapper = require("./lazy_wrapper");
var _copy_saved_objects_to_space = require("../copy_saved_objects_to_space");
var _legacy_urls = require("../legacy_urls");
var _share_saved_objects_to_space = require("../share_saved_objects_to_space");
var _space_avatar = require("../space_avatar");
var _space_list = require("../space_list");
var _spaces_context = require("../spaces_context");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765022786381327106/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/spaces/public/ui_api/components.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const getComponents = ({
  spacesManager,
  getStartServices
}) => {
  /**
   * Returns a function that creates a lazy-loading version of a component.
   */
  function wrapLazy(fn, options = {}) {
    const {
      showLoadingSpinner
    } = options;
    return props => /*#__PURE__*/_react.default.createElement(_lazy_wrapper.LazyWrapper, {
      fn: fn,
      getStartServices: getStartServices,
      props: props,
      showLoadingSpinner: showLoadingSpinner,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 42,
        columnNumber: 7
      }
    });
  }
  return {
    getSpacesContextProvider: wrapLazy(() => (0, _spaces_context.getSpacesContextProviderWrapper)({
      spacesManager,
      getStartServices
    })),
    getShareToSpaceFlyout: wrapLazy(_share_saved_objects_to_space.getShareToSpaceFlyoutComponent, {
      showLoadingSpinner: false
    }),
    getCopyToSpaceFlyout: wrapLazy(_copy_saved_objects_to_space.getCopyToSpaceFlyoutComponent, {
      showLoadingSpinner: false
    }),
    getSpaceList: wrapLazy(_space_list.getSpaceListComponent),
    getEmbeddableLegacyUrlConflict: wrapLazy(() => (0, _legacy_urls.getEmbeddableLegacyUrlConflict)({
      spacesManager,
      getStartServices
    })),
    getLegacyUrlConflict: wrapLazy(() => (0, _legacy_urls.getLegacyUrlConflict)({
      getStartServices
    })),
    getSpaceAvatar: wrapLazy(_space_avatar.getSpaceAvatarComponent)
  };
};
exports.getComponents = getComponents;