"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useEditSpaceStore = exports.useEditSpaceServices = exports.EditSpaceProviderRoot = exports.EditSpaceProvider = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _lodash = require("lodash");
var _react = _interopRequireWildcard(require("react"));
var _reducers = require("./reducers");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765022786381327106/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/spaces/public/management/edit_space/provider/edit_space_provider.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const createSpaceRolesContext = (0, _lodash.once)(() => /*#__PURE__*/(0, _react.createContext)(null));
const createEditSpaceServicesContext = (0, _lodash.once)(() => /*#__PURE__*/(0, _react.createContext)(null));

/**
 *
 * @description EditSpaceProvider is a provider component that wraps the children components with the necessary context providers for the Edit Space feature. It provides the necessary services and state management for the feature,
 * this is provided as an export for use with out of band renders within the spaces app
 */
const EditSpaceProvider = ({
  children,
  state,
  dispatch,
  ...services
}) => {
  const EditSpaceStoreContext = createSpaceRolesContext();
  const EditSpaceServicesContext = createEditSpaceServicesContext();
  return /*#__PURE__*/_react.default.createElement(EditSpaceServicesContext.Provider, {
    value: services,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 98,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(EditSpaceStoreContext.Provider, {
    value: {
      state,
      dispatch
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 99,
      columnNumber: 7
    }
  }, children));
};

/**
 * @description EditSpaceProviderRoot is the root provider for the Edit Space feature. It instantiates the necessary services and state management for the feature. It ideally
 * should only be rendered once
 */
exports.EditSpaceProvider = EditSpaceProvider;
const EditSpaceProviderRoot = ({
  children,
  ...services
}) => {
  const {
    logger,
    getRolesAPIClient,
    getPrivilegesAPIClient,
    getSecurityLicense,
    getIsRoleManagementEnabled
  } = services;
  const [isRoleManagementEnabled, setIsRoleManagementEnabled] = (0, _react.useState)(false);
  const clients = (0, _react.useRef)(Promise.all([getRolesAPIClient(), getPrivilegesAPIClient()]));
  const license = (0, _react.useRef)(getSecurityLicense);
  const licenseRef = (0, _react.useRef)();
  const rolesAPIClientRef = (0, _react.useRef)();
  const privilegesClientRef = (0, _react.useRef)();
  const initialStoreState = (0, _react.useRef)({
    roles: new Map(),
    fetchRolesError: false
  });
  const resolveSecurityLicense = (0, _react.useCallback)(async () => {
    try {
      licenseRef.current = await license.current();
    } catch (err) {
      logger.error('Could not resolve Security License!', err);
    }
  }, [logger]);
  const resolveAPIClients = (0, _react.useCallback)(async () => {
    try {
      [rolesAPIClientRef.current, privilegesClientRef.current] = await clients.current;
    } catch (err) {
      logger.error('Could not resolve API Clients!', err);
    }
  }, [logger]);
  (0, _react.useEffect)(() => {
    resolveAPIClients();
  }, [resolveAPIClients]);
  (0, _react.useEffect)(() => {
    resolveSecurityLicense();
  }, [resolveSecurityLicense]);
  const createInitialState = (0, _react.useCallback)(state => {
    return state;
  }, []);
  const [state, dispatch] = (0, _react.useReducer)(_reducers.createSpaceRolesReducer, initialStoreState.current, createInitialState);
  const invokeClient = (0, _react.useCallback)(async (...args) => {
    await resolveAPIClients();
    return args[0]({
      spacesManager: services.spacesManager,
      rolesClient: rolesAPIClientRef.current,
      privilegesClient: privilegesClientRef.current
    });
  }, [resolveAPIClients, services.spacesManager]);
  getIsRoleManagementEnabled().then(isEnabledFunction => {
    const result = isEnabledFunction();
    setIsRoleManagementEnabled(typeof result === 'undefined' || result);
  });
  return /*#__PURE__*/_react.default.createElement(EditSpaceProvider, (0, _extends2.default)({}, services, {
    invokeClient,
    state,
    dispatch,
    license: licenseRef.current,
    isRoleManagementEnabled,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 188,
      columnNumber: 5
    }
  }), children);
};
exports.EditSpaceProviderRoot = EditSpaceProviderRoot;
const useEditSpaceServices = () => {
  const context = (0, _react.useContext)(createEditSpaceServicesContext());
  if (!context) {
    throw new Error('EditSpaceService Context is missing. Ensure the component or React root is wrapped with EditSpaceProvider');
  }
  return context;
};
exports.useEditSpaceServices = useEditSpaceServices;
const useEditSpaceStore = () => {
  const context = (0, _react.useContext)(createSpaceRolesContext());
  if (!context) {
    throw new Error('EditSpaceStore Context is missing. Ensure the component or React root is wrapped with EditSpaceProvider');
  }
  return context;
};
exports.useEditSpaceStore = useEditSpaceStore;