"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getTabs = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _sharedUxUtility = require("@kbn/shared-ux-utility");
var _constants = require("./constants");
var _security_disabled_callout = require("./security_disabled_callout");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765022786381327106/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/spaces/public/management/edit_space/edit_space_tabs.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const SuspenseEditSpaceSettingsTab = (0, _sharedUxUtility.withSuspense)(/*#__PURE__*/_react.default.lazy(() => Promise.resolve().then(() => _interopRequireWildcard(require('./edit_space_general_tab'))).then(({
  EditSpaceSettingsTab
}) => ({
  default: EditSpaceSettingsTab
}))));
const SuspenseEditSpaceAssignedRolesTab = (0, _sharedUxUtility.withSuspense)(/*#__PURE__*/_react.default.lazy(() => Promise.resolve().then(() => _interopRequireWildcard(require('./edit_space_roles_tab'))).then(({
  EditSpaceAssignedRolesTab
}) => ({
  default: EditSpaceAssignedRolesTab
}))));
const SuspenseEditSpaceContentTab = (0, _sharedUxUtility.withSuspense)(/*#__PURE__*/_react.default.lazy(() => Promise.resolve().then(() => _interopRequireWildcard(require('./edit_space_content_tab'))).then(({
  EditSpaceContentTab
}) => ({
  default: EditSpaceContentTab
}))));
const getTabs = ({
  space,
  features,
  history,
  capabilities,
  rolesCount,
  isRoleManagementEnabled,
  isSecurityEnabled,
  enableSecurityLink,
  ...props
}) => {
  var _capabilities$roles, _capabilities$roles2;
  const reloadWindow = () => {
    window.location.reload();
  };
  const tabsDefinition = [{
    id: _constants.TAB_ID_GENERAL,
    name: _i18n.i18n.translate('xpack.spaces.management.spaceDetails.contentTabs.general.heading', {
      defaultMessage: 'General settings'
    }),
    content: /*#__PURE__*/_react.default.createElement(SuspenseEditSpaceSettingsTab, (0, _extends2.default)({
      space: space,
      features: features,
      history: history,
      reloadWindow: reloadWindow
    }, props, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 89,
        columnNumber: 9
      }
    }))
  }];
  const canUserViewRoles = Boolean(capabilities === null || capabilities === void 0 ? void 0 : (_capabilities$roles = capabilities.roles) === null || _capabilities$roles === void 0 ? void 0 : _capabilities$roles.view);
  const canUserModifyRoles = Boolean(capabilities === null || capabilities === void 0 ? void 0 : (_capabilities$roles2 = capabilities.roles) === null || _capabilities$roles2 === void 0 ? void 0 : _capabilities$roles2.save);
  if (canUserViewRoles && isRoleManagementEnabled) {
    tabsDefinition.push({
      id: _constants.TAB_ID_ROLES,
      name: _i18n.i18n.translate('xpack.spaces.management.spaceDetails.contentTabs.roles.heading', {
        defaultMessage: 'Permissions'
      }),
      append: /*#__PURE__*/_react.default.createElement(_eui.EuiNotificationBadge, {
        className: "eui-alignCenter",
        color: "subdued",
        size: "m",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 109,
          columnNumber: 9
        }
      }, rolesCount !== null && rolesCount !== void 0 ? rolesCount : 0),
      content: isSecurityEnabled ? /*#__PURE__*/_react.default.createElement(SuspenseEditSpaceAssignedRolesTab, {
        space: space,
        features: features,
        isReadOnly: !canUserModifyRoles,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 114,
          columnNumber: 9
        }
      }) : /*#__PURE__*/_react.default.createElement(_security_disabled_callout.SecurityDisabledCallout, {
        enableSecurityLink: enableSecurityLink,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 120,
          columnNumber: 9
        }
      })
    });
  }
  tabsDefinition.push({
    id: _constants.TAB_ID_CONTENT,
    name: _i18n.i18n.translate('xpack.spaces.management.spaceDetails.contentTabs.content.heading', {
      defaultMessage: 'Content'
    }),
    content: /*#__PURE__*/_react.default.createElement(SuspenseEditSpaceContentTab, {
      space: space,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 130,
        columnNumber: 14
      }
    })
  });
  return tabsDefinition;
};
exports.getTabs = getTabs;