"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ResolveAllConflicts = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
var _react2 = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765022786381327106/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/spaces/public/copy_saved_objects_to_space/components/resolve_all_conflicts.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const options = [{
  id: 'overwrite',
  text: _i18n.i18n.translate('xpack.spaces.management.copyToSpace.overwriteAllConflictsText', {
    defaultMessage: 'Overwrite all'
  })
}, {
  id: 'skip',
  text: _i18n.i18n.translate('xpack.spaces.management.copyToSpace.skipAllConflictsText', {
    defaultMessage: 'Skip all'
  })
}];
const ResolveAllButton = ({
  onButtonClick
}) => {
  const {
    fontSize
  } = (0, _eui.useEuiFontSize)('s');
  return /*#__PURE__*/_react2.default.createElement(_eui.EuiLink, {
    onClick: onButtonClick,
    css: (0, _react.css)`
        font-size: ${fontSize};
      `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 62,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react2.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.spaces.management.copyToSpace.resolveAllConflictsLink",
    defaultMessage: "(resolve all)",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 68,
      columnNumber: 7
    }
  }));
};
class ResolveAllConflicts extends _react2.Component {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "state", {
      isPopoverOpen: false
    });
    (0, _defineProperty2.default)(this, "onSelect", selection => {
      const {
        summarizedCopyResult,
        retries,
        onRetriesChange,
        onDestinationMapChange
      } = this.props;
      const overwrite = selection === 'overwrite';
      if (overwrite) {
        const existingOverwrites = retries.filter(retry => retry.overwrite === true);
        const newOverwrites = summarizedCopyResult.objects.reduce((acc, {
          type,
          id,
          conflict
        }) => {
          if (conflict && !existingOverwrites.some(retry => retry.type === type && retry.id === id)) {
            const {
              error
            } = conflict;
            // if this is a regular conflict, use its destinationId if it has one;
            // otherwise, this is an ambiguous conflict, so use the first destinationId available
            const destinationId = error.type === 'conflict' ? error.destinationId : error.destinations[0].id;
            return [...acc, {
              type,
              id,
              overwrite,
              ...(destinationId && {
                destinationId
              })
            }];
          }
          return acc;
        }, new Array());
        onRetriesChange([...retries, ...newOverwrites]);
      } else {
        const objectsToSkip = summarizedCopyResult.objects.reduce((acc, {
          type,
          id,
          conflict
        }) => conflict ? acc.add(`${type}:${id}`) : acc, new Set());
        const filtered = retries.filter(({
          type,
          id
        }) => !objectsToSkip.has(`${type}:${id}`));
        onRetriesChange(filtered);
        onDestinationMapChange(undefined);
      }
      this.setState({
        isPopoverOpen: false
      });
    });
    (0, _defineProperty2.default)(this, "onButtonClick", () => {
      this.setState({
        isPopoverOpen: !this.state.isPopoverOpen
      });
    });
    (0, _defineProperty2.default)(this, "closePopover", () => {
      this.setState({
        isPopoverOpen: false
      });
    });
  }
  render() {
    const button = /*#__PURE__*/_react2.default.createElement(ResolveAllButton, {
      onButtonClick: this.onButtonClick,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 82,
        columnNumber: 20
      }
    });
    const items = options.map(item => {
      return /*#__PURE__*/_react2.default.createElement(_eui.EuiContextMenuItem, {
        "data-test-subj": `cts-resolve-all-conflicts-${item.id}`,
        key: item.id,
        onClick: () => {
          this.onSelect(item.id);
        },
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 86,
          columnNumber: 9
        }
      }, item.text);
    });
    return /*#__PURE__*/_react2.default.createElement(_eui.EuiPopover, {
      id: 'resolveAllConflictsVisibilityPopover',
      button: button,
      isOpen: this.state.isPopoverOpen,
      closePopover: this.closePopover,
      panelPaddingSize: "none",
      anchorPosition: "downLeft",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 99,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react2.default.createElement(_eui.EuiContextMenuPanel, {
      items: items,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 107,
        columnNumber: 9
      }
    }));
  }
}
exports.ResolveAllConflicts = ResolveAllConflicts;