"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RepositoryList = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _public = require("@kbn/kibana-react-plugin/public");
var _shared_imports = require("../../../../shared_imports");
var _lib = require("../../../lib");
var _constants = require("../../../constants");
var _app_context = require("../../../app_context");
var _http = require("../../../services/http");
var _navigation = require("../../../services/navigation");
var _repository_details = require("./repository_details");
var _repository_table = require("./repository_table");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765022786381327106/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/snapshot_restore/public/application/sections/home/repository_list/repository_list.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const RepositoryList = ({
  history
}) => {
  const {
    repositoryName
  } = (0, _lib.useDecodedParams)();
  const {
    error,
    isLoading,
    data: {
      repositories,
      managedRepository
    } = {
      repositories: undefined,
      managedRepository: {
        name: undefined
      }
    },
    resendRequest: reload
  } = (0, _http.useLoadRepositories)();
  const {
    uiMetricService
  } = (0, _app_context.useServices)();
  const {
    core
  } = (0, _app_context.useAppContext)();
  const openRepositoryDetailsUrl = newRepositoryName => {
    return (0, _navigation.linkToRepository)(newRepositoryName);
  };
  const closeRepositoryDetails = () => {
    history.push(`${_constants.BASE_PATH}/repositories`);
  };
  const onRepositoryDeleted = repositoriesDeleted => {
    if (repositoryName && repositoriesDeleted.includes(repositoryName)) {
      closeRepositoryDetails();
    }
    if (repositoriesDeleted.length) {
      reload();
    }
  };

  // Track component loaded
  (0, _react.useEffect)(() => {
    uiMetricService.trackUiMetric(_constants.UIM_REPOSITORY_LIST_LOAD);
  }, [uiMetricService]);
  (0, _shared_imports.useExecutionContext)(core.executionContext, {
    type: 'application',
    page: 'snapshotRestoreRepositoryTab'
  });
  let content;
  if (isLoading) {
    content = /*#__PURE__*/_react.default.createElement(_shared_imports.PageLoading, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 81,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.repositoryList.loadingRepositoriesDescription",
      defaultMessage: "Loading repositories\u2026",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 82,
        columnNumber: 9
      }
    }));
  } else if (error) {
    content = /*#__PURE__*/_react.default.createElement(_shared_imports.PageError, {
      title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.snapshotRestore.repositoryList.LoadingRepositoriesErrorMessage",
        defaultMessage: "Error loading repositories",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 92,
          columnNumber: 11
        }
      }),
      error: error,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 90,
        columnNumber: 7
      }
    });
  } else if (repositories && repositories.length === 0) {
    content = /*#__PURE__*/_react.default.createElement(_eui.EuiPageTemplate.EmptyPrompt, {
      iconType: "managementApp",
      title: /*#__PURE__*/_react.default.createElement("h1", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 105,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.snapshotRestore.repositoryList.emptyPromptTitle",
        defaultMessage: "Register your first repository",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 106,
          columnNumber: 13
        }
      })),
      body: /*#__PURE__*/_react.default.createElement(_react.Fragment, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 113,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement("p", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 114,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.snapshotRestore.repositoryList.emptyPromptDescription",
        defaultMessage: "Create a place where your snapshots will live.",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 115,
          columnNumber: 15
        }
      }))),
      actions: /*#__PURE__*/_react.default.createElement(_eui.EuiButton, (0, _extends2.default)({}, (0, _public.reactRouterNavigate)(history, (0, _navigation.linkToAddRepository)()), {
        fill: true,
        iconType: "plusInCircle",
        "data-test-subj": "registerRepositoryButton",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 123,
          columnNumber: 11
        }
      }), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.snapshotRestore.addRepositoryButtonLabel",
        defaultMessage: "Register a repository",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 129,
          columnNumber: 13
        }
      })),
      "data-test-subj": "emptyPrompt",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 102,
        columnNumber: 7
      }
    });
  } else {
    content = /*#__PURE__*/_react.default.createElement("section", {
      "data-test-subj": "repositoryList",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 140,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_repository_table.RepositoryTable, {
      repositories: repositories || [],
      managedRepository: managedRepository === null || managedRepository === void 0 ? void 0 : managedRepository.name,
      reload: reload,
      openRepositoryDetailsUrl: openRepositoryDetailsUrl,
      onRepositoryDeleted: onRepositoryDeleted,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 141,
        columnNumber: 9
      }
    }));
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, repositoryName ? /*#__PURE__*/_react.default.createElement(_repository_details.RepositoryDetails, {
    repositoryName: repositoryName,
    onClose: closeRepositoryDetails,
    onRepositoryDeleted: onRepositoryDeleted,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 155,
      columnNumber: 9
    }
  }) : null, content);
};
exports.RepositoryList = RepositoryList;