"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TabSummary = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _public = require("@kbn/kibana-react-plugin/public");
var _app_context = require("../../../../../app_context");
var _components = require("../../../../../components");
var _navigation = require("../../../../../services/navigation");
var _summaries = require("../../../../../components/summaries");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765022786381327106/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/snapshot_restore/public/application/sections/home/policy_list/policy_details/tabs/tab_summary.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const TabSummary = ({
  policy
}) => {
  const {
    i18n,
    history
  } = (0, _app_context.useServices)();
  const {
    version,
    name,
    modifiedDateMillis,
    snapshotName,
    repository,
    schedule,
    nextExecutionMillis,
    config,
    stats,
    retention,
    isManagedPolicy
  } = policy;
  const {
    includeGlobalState,
    featureStates,
    ignoreUnavailable,
    indices,
    partial
  } = config || {
    includeGlobalState: undefined,
    featureStates: [],
    ignoreUnavailable: undefined,
    indices: undefined,
    partial: undefined
  };
  return /*#__PURE__*/_react.default.createElement(_react.Fragment, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 61,
      columnNumber: 5
    }
  }, isManagedPolicy ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    size: "s",
    color: "warning",
    iconType: "info",
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.policyDetails.managedPolicyWarningTitle",
      defaultMessage: "This is a managed policy used by other systems. Any changes you make might affect how these systems operate.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 69,
        columnNumber: 15
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 64,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 75,
      columnNumber: 11
    }
  })) : null, stats && /*#__PURE__*/_react.default.createElement(_react.Fragment, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 80,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 81,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 82,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 83,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiStat, {
    title: stats.snapshotsTaken,
    description: i18n.translate('xpack.snapshotRestore.policyDetails.snapshotsTakenStat', {
      defaultMessage: 'Snapshots taken'
    }),
    titleSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 84,
      columnNumber: 17
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 95,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiStat, {
    title: stats.snapshotsFailed,
    description: i18n.translate('xpack.snapshotRestore.policyDetails.snapshotsFailedStat', {
      defaultMessage: 'Failures'
    }),
    titleSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 96,
      columnNumber: 17
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 107,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiStat, {
    title: stats.snapshotsDeleted,
    description: i18n.translate('xpack.snapshotRestore.policyDetails.snapshotsDeletedStat', {
      defaultMessage: 'Deleted'
    }),
    titleSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 108,
      columnNumber: 17
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 119,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiStat, {
    title: stats.snapshotDeletionFailures,
    description: i18n.translate('xpack.snapshotRestore.policyDetails.snapshotDeletionFailuresStat', {
      defaultMessage: 'Deletion failures'
    }),
    titleSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 120,
      columnNumber: 17
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 134,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 139,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("h3", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 140,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.snapshotRestore.policyDetails.generalTitle",
    defaultMessage: "General",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 141,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 147,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 149,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": "version",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 150,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
    textStyle: "reverse",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 151,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, {
    "data-test-subj": "title",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 152,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.snapshotRestore.policyDetails.versionLabel",
    defaultMessage: "Version",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 153,
      columnNumber: 15
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, {
    className: "eui-textBreakWord",
    "data-test-subj": "value",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 159,
      columnNumber: 13
    }
  }, version))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": "modified",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 165,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
    textStyle: "reverse",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 166,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, {
    "data-test-subj": "title",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 167,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.snapshotRestore.policyDetails.modifiedDateLabel",
    defaultMessage: "Last modified",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 168,
      columnNumber: 15
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, {
    className: "eui-textBreakWord",
    "data-test-subj": "value",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 174,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_components.FormattedDateTime, {
    epochMs: modifiedDateMillis,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 175,
      columnNumber: 15
    }
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 180,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 182,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": "name",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 183,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
    textStyle: "reverse",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 184,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, {
    "data-test-subj": "title",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 185,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.snapshotRestore.policyDetails.snapshotNameLabel",
    defaultMessage: "Snapshot name",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 186,
      columnNumber: 15
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, {
    className: "eui-textBreakWord",
    "data-test-subj": "value",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 192,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, (0, _extends2.default)({}, (0, _public.reactRouterNavigate)(history, (0, _navigation.linkToSnapshots)(undefined, name)), {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 193,
      columnNumber: 15
    }
  }), snapshotName)))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": "repository",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 200,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
    textStyle: "reverse",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 201,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, {
    "data-test-subj": "title",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 202,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.snapshotRestore.policyDetails.repositoryLabel",
    defaultMessage: "Repository",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 203,
      columnNumber: 15
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, {
    className: "eui-textBreakWord",
    "data-test-subj": "value",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 209,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, (0, _extends2.default)({}, (0, _public.reactRouterNavigate)(history, (0, _navigation.linkToRepository)(repository)), {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 210,
      columnNumber: 15
    }
  }), repository))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 217,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 219,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": "schedule",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 220,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
    textStyle: "reverse",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 221,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, {
    "data-test-subj": "title",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 222,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.snapshotRestore.policyDetails.scheduleLabel",
    defaultMessage: "Schedule",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 223,
      columnNumber: 15
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, {
    className: "eui-textBreakWord",
    "data-test-subj": "value",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 229,
      columnNumber: 13
    }
  }, schedule))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": "execution",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 235,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
    textStyle: "reverse",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 236,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, {
    "data-test-subj": "title",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 237,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.snapshotRestore.policyDetails.nextExecutionLabel",
    defaultMessage: "Next snapshot",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 238,
      columnNumber: 15
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, {
    className: "eui-textBreakWord",
    "data-test-subj": "value",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 244,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_components.FormattedDateTime, {
    epochMs: nextExecutionMillis,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 245,
      columnNumber: 15
    }
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 250,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 252,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": "indices",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 253,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
    textStyle: "reverse",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 254,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, {
    "data-test-subj": "title",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 255,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.snapshotRestore.policyDetails.dataStreamsAndIndicesLabel",
    defaultMessage: "Data streams and indices",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 256,
      columnNumber: 15
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, {
    className: "eui-textBreakWord",
    "data-test-subj": "value",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 262,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_components.CollapsibleIndicesList, {
    indices: indices,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 263,
      columnNumber: 15
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": "ignoreUnavailable",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 268,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
    textStyle: "reverse",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 269,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, {
    "data-test-subj": "title",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 270,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.snapshotRestore.policyDetails.ignoreUnavailableLabel",
    defaultMessage: "Ignore unavailable indices",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 271,
      columnNumber: 15
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, {
    className: "eui-textBreakWord",
    "data-test-subj": "value",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 277,
      columnNumber: 13
    }
  }, ignoreUnavailable ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.snapshotRestore.policyDetails.ignoreUnavailableTrueLabel",
    defaultMessage: "Yes",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 279,
      columnNumber: 17
    }
  }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.snapshotRestore.policyDetails.ignoreUnavailableFalseLabel",
    defaultMessage: "No",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 284,
      columnNumber: 17
    }
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 293,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 295,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": "includeGlobalState",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 296,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
    textStyle: "reverse",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 297,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, {
    "data-test-subj": "title",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 298,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.snapshotRestore.policyDetails.includeGlobalStateLabel",
    defaultMessage: "Include global state",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 299,
      columnNumber: 15
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, {
    className: "eui-textBreakWord",
    "data-test-subj": "value",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 305,
      columnNumber: 13
    }
  }, includeGlobalState === false ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    "data-test-subj": "withoutGlobalState",
    id: "xpack.snapshotRestore.policyDetails.includeGlobalStateFalseLabel",
    defaultMessage: "No",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 307,
      columnNumber: 17
    }
  }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    "data-test-subj": "withGlobalStateAndFeatureStates",
    id: "xpack.snapshotRestore.policyDetails.includeGlobalStateTrueLabel",
    defaultMessage: "Yes",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 313,
      columnNumber: 17
    }
  })))), /*#__PURE__*/_react.default.createElement(_summaries.PolicyFeatureStatesSummary, {
    includeGlobalState: includeGlobalState,
    featureStates: featureStates,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 323,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 328,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 330,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": "partial",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 331,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
    textStyle: "reverse",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 332,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, {
    "data-test-subj": "title",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 333,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.snapshotRestore.policyDetails.partialLabel",
    defaultMessage: "Allow partial shards",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 334,
      columnNumber: 15
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, {
    className: "eui-textBreakWord",
    "data-test-subj": "value",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 340,
      columnNumber: 13
    }
  }, partial ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.snapshotRestore.policyDetails.partialTrueLabel",
    defaultMessage: "Yes",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 342,
      columnNumber: 17
    }
  }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.snapshotRestore.policyDetails.partialFalseLabel",
    defaultMessage: "No",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 347,
      columnNumber: 17
    }
  }))))), retention && /*#__PURE__*/_react.default.createElement(_react.Fragment, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 358,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 359,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 360,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 363,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("h3", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 364,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.snapshotRestore.policyDetails.retentionTitle",
    defaultMessage: "Retention",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 365,
      columnNumber: 15
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 371,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
    textStyle: "reverse",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 373,
      columnNumber: 11
    }
  }, retention.expireAfterValue && /*#__PURE__*/_react.default.createElement(_react.Fragment, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 375,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 376,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.snapshotRestore.policyDetails.expireAfterLabel",
    defaultMessage: "Delete after",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 377,
      columnNumber: 19
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 382,
      columnNumber: 17
    }
  }, retention.expireAfterValue, retention.expireAfterUnit)), retention.minCount && /*#__PURE__*/_react.default.createElement(_react.Fragment, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 389,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 390,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.snapshotRestore.policyDetails.minCountLabel",
    defaultMessage: "Min count",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 391,
      columnNumber: 19
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 396,
      columnNumber: 17
    }
  }, retention.minCount)), retention.maxCount && /*#__PURE__*/_react.default.createElement(_react.Fragment, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 400,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 401,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.snapshotRestore.policyDetails.maxCountLabel",
    defaultMessage: "Max count",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 402,
      columnNumber: 19
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 407,
      columnNumber: 17
    }
  }, retention.maxCount)))));
};
exports.TabSummary = TabSummary;