"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SystemIndicesOverwrittenCallOut = void 0;
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765022786381327106/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/snapshot_restore/public/application/components/restore_snapshot_form/steps/step_logistics/system_indices_overwritten_callout.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const SystemIndicesOverwrittenCallOut = ({
  featureStates
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    "data-test-subj": "systemIndicesInfoCallOut",
    title: _i18n.i18n.translate('xpack.snapshotRestore.restoreForm.stepLogistics.systemIndicesCallOut.title', {
      defaultMessage: 'When this snapshot is restored, system indices {featuresCount, plural, =0 {} other {from {features}}} will be overwritten with data from the snapshot.',
      values: {
        featuresCount: (featureStates === null || featureStates === void 0 ? void 0 : featureStates.length) || 0,
        features: featureStates === null || featureStates === void 0 ? void 0 : featureStates.join(', ')
      }
    }),
    iconType: "pin",
    size: "s",
    "aria-live": "polite",
    "aria-atomic": "true",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 17,
      columnNumber: 5
    }
  });
};
exports.SystemIndicesOverwrittenCallOut = SystemIndicesOverwrittenCallOut;