"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RestoreSnapshotNavigation = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _app_context = require("../../app_context");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765022786381327106/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/snapshot_restore/public/application/components/restore_snapshot_form/navigation.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const RestoreSnapshotNavigation = ({
  currentStep,
  maxCompletedStep,
  updateCurrentStep
}) => {
  const {
    i18n
  } = (0, _app_context.useServices)();
  const steps = [{
    title: i18n.translate('xpack.snapshotRestore.restoreForm.navigation.stepLogisticsName', {
      defaultMessage: 'Logistics'
    }),
    status: currentStep === 1 ? 'selected' : maxCompletedStep >= 1 ? 'complete' : 'incomplete',
    onClick: () => updateCurrentStep(1)
  }, {
    title: i18n.translate('xpack.snapshotRestore.restoreForm.navigation.stepSettingsName', {
      defaultMessage: 'Index settings'
    }),
    status: currentStep === 2 ? 'selected' : maxCompletedStep >= 2 ? 'complete' : 'incomplete',
    disabled: maxCompletedStep < 1,
    onClick: () => updateCurrentStep(2)
  }, {
    title: i18n.translate('xpack.snapshotRestore.restoreForm.navigation.stepReviewName', {
      defaultMessage: 'Review'
    }),
    status: currentStep === 3 ? 'selected' : maxCompletedStep >= 2 ? 'complete' : 'incomplete',
    disabled: maxCompletedStep < 2,
    onClick: () => updateCurrentStep(3)
  }];
  return /*#__PURE__*/_react.default.createElement(_eui.EuiStepsHorizontal, {
    steps: steps,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 64,
      columnNumber: 10
    }
  });
};
exports.RestoreSnapshotNavigation = RestoreSnapshotNavigation;