"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IndicesAndDataStreamsField = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _app_context = require("../../../../../../app_context");
var _lib = require("../../../../../lib");
var _data_stream_badge = require("../../../../../data_stream_badge");
var _styles = require("../../../../../styles");
var _helpers = require("./helpers");
var _data_streams_and_indices_list_help_text = require("./data_streams_and_indices_list_help_text");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765022786381327106/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/snapshot_restore/public/application/components/policy_form/steps/step_settings/fields/indices_and_data_streams_field/indices_and_data_streams_field.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const styles = {
  indicesFieldWrapper: _styles.indicesFieldWrapperStyle
};
/**
 * In future we may be able to split data streams to its own field, but for now
 * they share an array "indices" in the snapshot lifecycle policy config. See
 * this github issue for progress: https://github.com/elastic/elasticsearch/issues/58474
 */
const IndicesAndDataStreamsField = ({
  isManagedPolicy,
  dataStreams,
  indices,
  policy,
  onUpdate: _onUpdate,
  errors
}) => {
  const {
    i18n
  } = (0, _app_context.useServices)();
  const {
    config = {}
  } = policy;
  const indicesAndDataStreams = indices.concat(dataStreams);

  // We assume all indices if the config has no indices entry or if we receive an empty array
  const [isAllIndices, setIsAllIndices] = (0, _react.useState)(config.indices == null || Array.isArray(config.indices) && config.indices.length === 0);
  const onUpdate = data => {
    _onUpdate(data, {
      validateIndicesCount: !isAllIndices
    });
  };
  const [indicesAndDataStreamsSelection, setIndicesAndDataStreamsSelection] = (0, _react.useState)(() => Array.isArray(config.indices) && !isAllIndices ? indicesAndDataStreams.filter(i => config.indices.includes(i)) : [...indicesAndDataStreams]);

  // States for choosing all indices, or a subset, including caching previously chosen subset list
  const [indicesAndDataStreamsOptions, setIndicesAndDataStreamsOptions] = (0, _react.useState)(() => (0, _helpers.mapSelectionToIndicesOptions)({
    selection: indicesAndDataStreamsSelection,
    dataStreams,
    indices,
    allSelected: isAllIndices || typeof config.indices === 'string'
  }));

  // State for using selectable indices list or custom patterns
  const [selectIndicesMode, setSelectIndicesMode] = (0, _react.useState)(() => (0, _helpers.determineListMode)({
    configuredIndices: config.indices,
    dataStreams,
    indices
  }));

  // State for custom patterns
  const [indexPatterns, setIndexPatterns] = (0, _react.useState)(() => typeof config.indices === 'string' ? config.indices.split(',') : Array.isArray(config.indices) && config.indices ? config.indices : []);
  const indicesSwitch = /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.policyForm.stepSettings.allDataStreamsAndIndicesLabel",
      defaultMessage: "All data streams and indices",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 125,
        columnNumber: 9
      }
    }),
    checked: isAllIndices,
    disabled: isManagedPolicy,
    "data-test-subj": "allIndicesToggle",
    onChange: e => {
      const isChecked = e.target.checked;
      setIsAllIndices(isChecked);
      if (isChecked) {
        setIndicesAndDataStreamsSelection(indicesAndDataStreams);
        setIndicesAndDataStreamsOptions((0, _helpers.mapSelectionToIndicesOptions)({
          allSelected: isAllIndices || typeof config.indices === 'string',
          dataStreams,
          indices,
          selection: indicesAndDataStreamsSelection
        }));
        onUpdate({
          indices: undefined
        });
      } else {
        _onUpdate({
          indices: selectIndicesMode === 'custom' ? indexPatterns.join(',') : [...(indicesAndDataStreamsSelection || [])]
        }, {
          validateIndicesCount: true
        });
      }
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 123,
      columnNumber: 5
    }
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiDescribedFormGroup, {
    title: /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 167,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement("h3", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 168,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.policyForm.stepSettings.dataStreamsAndIndicesTitle",
      defaultMessage: "Data streams and indices",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 169,
        columnNumber: 13
      }
    }))),
    description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.policyForm.stepSettings.dataStreamsAndIndicesDescription",
      defaultMessage: "To back up indices and data streams, manually select them or define index patterns to dynamically match them.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 177,
        columnNumber: 9
      }
    }),
    fullWidth: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 165,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 184,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_react.Fragment, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 185,
      columnNumber: 9
    }
  }, isManagedPolicy ? /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    position: "left",
    content: /*#__PURE__*/_react.default.createElement("p", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 190,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.policyForm.stepSettings.indicesTooltip",
      defaultMessage: "Cloud-managed policies require all indices.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 191,
        columnNumber: 19
      }
    })),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 187,
      columnNumber: 13
    }
  }, indicesSwitch) : indicesSwitch, isAllIndices ? null : /*#__PURE__*/_react.default.createElement(_react.Fragment, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 204,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 205,
      columnNumber: 15
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    css: styles.indicesFieldWrapper,
    label: selectIndicesMode === 'list' ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      justifyContent: "spaceBetween",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 210,
        columnNumber: 21
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 211,
        columnNumber: 23
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.policyForm.stepSettings.selectIndicesLabel",
      defaultMessage: "Select indices and data streams",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 212,
        columnNumber: 25
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 217,
        columnNumber: 23
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      onClick: () => {
        setSelectIndicesMode('custom');
        onUpdate({
          indices: indexPatterns.join(',')
        });
      },
      "data-test-subj": "useIndexPatternsButton",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 218,
        columnNumber: 25
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.policyForm.stepSettings.indicesToggleCustomLink",
      defaultMessage: "Use index patterns",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 225,
        columnNumber: 27
      }
    })))) : /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      justifyContent: "spaceBetween",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 233,
        columnNumber: 21
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 234,
        columnNumber: 23
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.policyForm.stepSettings.indicesPatternLabel",
      defaultMessage: "Index patterns",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 235,
        columnNumber: 25
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 240,
        columnNumber: 23
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      "data-test-subj": "selectIndicesLink",
      onClick: () => {
        setSelectIndicesMode('list');
        onUpdate({
          indices: indicesAndDataStreamsSelection
        });
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 241,
        columnNumber: 25
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.policyForm.stepSettings.dataStreamsAndIndicesToggleListLink",
      defaultMessage: "Select data streams and indices",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 248,
        columnNumber: 27
      }
    })))),
    helpText: selectIndicesMode === 'list' ? /*#__PURE__*/_react.default.createElement(_data_streams_and_indices_list_help_text.DataStreamsAndIndicesListHelpText, {
      onSelectionChange: selection => {
        if (selection === 'all') {
          // TODO: Change this to setIndicesOptions() when https://github.com/elastic/eui/issues/2071 is fixed
          indicesAndDataStreamsOptions.forEach(option => {
            option.checked = 'on';
          });
          onUpdate({
            indices: [...indicesAndDataStreams]
          });
          setIndicesAndDataStreamsSelection([...indicesAndDataStreams]);
        } else {
          // TODO: Change this to setIndicesOptions() when https://github.com/elastic/eui/issues/2071 is fixed
          indicesAndDataStreamsOptions.forEach(option => {
            option.checked = undefined;
          });
          onUpdate({
            indices: []
          });
          setIndicesAndDataStreamsSelection([]);
        }
      },
      selectedIndicesAndDataStreams: indicesAndDataStreamsSelection,
      indices: indices,
      dataStreams: dataStreams,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 259,
        columnNumber: 21
      }
    }) : null,
    isInvalid: Boolean(errors.indices),
    error: errors.indices,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 206,
      columnNumber: 15
    }
  }, selectIndicesMode === 'list' ? /*#__PURE__*/_react.default.createElement(_eui.EuiSelectable, {
    allowExclusions: false,
    "data-test-subj": "indicesAndDataStreamsList",
    options: indicesAndDataStreamsOptions,
    onChange: options => {
      const newSelectedIndices = [];
      options.forEach(({
        label,
        checked
      }) => {
        if (checked === 'on') {
          newSelectedIndices.push(label);
        }
      });
      setIndicesAndDataStreamsOptions(options);
      onUpdate({
        indices: newSelectedIndices
      });
      setIndicesAndDataStreamsSelection(newSelectedIndices);
    },
    searchable: true,
    height: 300,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 287,
      columnNumber: 19
    }
  }, (list, search) => /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    paddingSize: "s",
    hasShadow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 306,
      columnNumber: 23
    }
  }, search, list)) : /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    options: (0, _lib.orderDataStreamsAndIndices)({
      indices: indices.map(index => ({
        label: index,
        value: {
          isDataStream: false
        }
      })),
      dataStreams: dataStreams.map(dataStream => ({
        label: dataStream,
        value: {
          isDataStream: true
        }
      }))
    }),
    renderOption: ({
      label,
      value
    }) => {
      if (value !== null && value !== void 0 && value.isDataStream) {
        return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
          responsive: false,
          justifyContent: "spaceBetween",
          alignItems: "center",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 327,
            columnNumber: 27
          }
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
          grow: false,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 332,
            columnNumber: 29
          }
        }, label), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
          grow: false,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 333,
            columnNumber: 29
          }
        }, /*#__PURE__*/_react.default.createElement(_data_stream_badge.DataStreamBadge, {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 334,
            columnNumber: 31
          }
        })));
      }
      return label;
    },
    placeholder: i18n.translate('xpack.snapshotRestore.policyForm.stepSettings.indicesPatternPlaceholder', {
      defaultMessage: 'Enter index patterns, i.e. logstash-*'
    }),
    selectedOptions: indexPatterns.map(pattern => ({
      label: pattern
    })),
    onCreateOption: pattern => {
      if (!pattern.trim().length) {
        return;
      }
      const newPatterns = [...indexPatterns, pattern];
      setIndexPatterns(newPatterns);
      onUpdate({
        indices: newPatterns.join(',')
      });
    },
    onChange: patterns => {
      const newPatterns = patterns.map(({
        label
      }) => label);
      setIndexPatterns(newPatterns);
      onUpdate({
        indices: newPatterns.join(',')
      });
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 313,
      columnNumber: 19
    }
  }))))));
};
exports.IndicesAndDataStreamsField = IndicesAndDataStreamsField;