"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CollapsibleIndicesList = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _use_collapsible_list = require("./use_collapsible_list");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765022786381327106/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/snapshot_restore/public/application/components/collapsible_lists/collapsible_indices_list.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const CollapsibleIndicesList = ({
  indices
}) => {
  const {
    hiddenItemsCount,
    isShowingFullList,
    items,
    setIsShowingFullList
  } = (0, _use_collapsible_list.useCollapsibleList)({
    items: indices
  });
  return items === 'all' ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.snapshotRestore.indicesList.allIndicesValue",
    defaultMessage: "All indices",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 23,
      columnNumber: 5
    }
  }) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 29,
      columnNumber: 7
    }
  }, items.map(index => /*#__PURE__*/_react.default.createElement("div", {
    key: index,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 31,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 32,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement("span", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 33,
      columnNumber: 15
    }
  }, index))))), hiddenItemsCount ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 40,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    onClick: () => isShowingFullList ? setIsShowingFullList(false) : setIsShowingFullList(true),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 41,
      columnNumber: 11
    }
  }, isShowingFullList ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.snapshotRestore.indicesList.indicesCollapseAllLink",
    defaultMessage: "Hide {count, plural, one {# index} other {# indices}}",
    values: {
      count: hiddenItemsCount
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 47,
      columnNumber: 15
    }
  }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.snapshotRestore.indicesList.indicesExpandAllLink",
    defaultMessage: "Show {count, plural, one {# index} other {# indices}}",
    values: {
      count: hiddenItemsCount
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 53,
      columnNumber: 15
    }
  }), ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: isShowingFullList ? 'arrowUp' : 'arrowDown',
    "data-test-subj": "collapsibleIndicesArrow",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 59,
      columnNumber: 13
    }
  }))) : null);
};
exports.CollapsibleIndicesList = CollapsibleIndicesList;