"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.evaluateDependencies = evaluateDependencies;
var _sloSchema = require("@kbn/slo-schema");
var _evaluate = require("./evaluate");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function evaluateDependencies(soClient, esClient, sloRepository, dependencies, startedAt) {
  const activeRules = await Promise.all(dependencies.map(async dependency => {
    const rule = await fetchRule(soClient, dependency.ruleId);
    const slo = await sloRepository.findById(rule.params.sloId);
    const paramsWithSuppressOnWindows = {
      ...rule.params,
      windows: rule.params.windows.filter(winDef => dependency.actionGroupsToSuppressOn.includes(winDef.actionGroup))
    };
    const results = await (0, _evaluate.evaluate)(esClient, slo, paramsWithSuppressOnWindows, startedAt);
    const instanceIdsToSuppress = results.filter(res => res.shouldAlert).map(res => res.instanceId);
    const suppressAll = instanceIdsToSuppress.length > 0 && instanceIdsToSuppress.every(id => id === _sloSchema.ALL_VALUE);
    return {
      rule,
      slo,
      instanceIdsToSuppress: suppressAll ? [] : instanceIdsToSuppress,
      suppressAll
    };
  }));
  return {
    activeRules
  };
}
async function fetchRule(soClient, ruleId) {
  const response = await soClient.get('alert', ruleId);
  return response.attributes;
}